( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"wvusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + wvus_map_try_config[id]['title']);
        var _abb = $('#' + wvus_map_try_config[id]['title']);
        $('#wvusmapwrapper-try').css({'opacity': '1'});

        if(wvus_map_try_config['default']['wvusshowvisns_try'] === true) {
            $('#wvusvisns-try').css({'fill': wvus_map_try_config['default']['wvusvisns_try']});
            $('#wvusvisns-try').css({'opacity': '1'});
        } else {
            $('#wvusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': wvus_map_try_config[id]['upclr'], 'stroke': wvus_map_try_config['default']['wvusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (wvus_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $wvusmtip = $('#tipwvusmap-try');
                            let wvusmaptipw = $wvusmtip.outerWidth(),
                                wvusmaptiph = $wvusmtip.outerHeight();

                            x = (x + wvusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - wvusmaptipw - (20 * 2) : x
                            y = (y + wvusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - wvusmaptiph - 10 : y

                            if (wvus_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': wvus_map_try_config[id]['dwnclr']});
                            }
                            $wvusmtip.show().html(wvus_map_try_config[id]['hover']);
                            $wvusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': wvus_map_try_config[id]['upclr']});
                            if (wvus_map_try_config[id]['targt'] === '_blank') {
                                window.open(wvus_map_try_config[id]['url']);
                            } else if (wvus_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = wvus_map_try_config[id]['url'];
                            }
                            $('#tipwvusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipwvusmap-try').show().html(wvus_map_try_config[id]['hover']);
                _obj.css({'fill': wvus_map_try_config[id]['ovrclr']});
                _abb.css({'fill': wvus_map_try_config['default']['wvusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipwvusmap-try').hide();
                _obj.css({'fill': wvus_map_try_config[id]['upclr']});
                _abb.css({'fill': wvus_map_try_config['default']['wvusvisns_try']});
            });
            if (wvus_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': wvus_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': wvus_map_try_config[id]['ovrclr']});
                if (wvus_map_try_config[id]['targt'] === '_blank') {
                    window.open(wvus_map_try_config[id]['url']);
                } else if (wvus_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = wvus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mwvus = $('#tipwvusmap-try');
                let wvusmaptipw = $mwvus.outerWidth(), wvusmaptiph = $mwvus.outerHeight();

                x = (x + wvusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - wvusmaptipw - (20 * 2) : x
                y = (y + wvusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - wvusmaptiph - 10 : y

                $mwvus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
