( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"wiusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + wius_map_try_config[id]['title']);
        var _abb = $('#' + wius_map_try_config[id]['title']);
        $('#wiusmapwrapper-try').css({'opacity': '1'});

        if(wius_map_try_config['default']['wiusshowvisns_try'] === true) {
            $('#wiusvisns-try').css({'fill': wius_map_try_config['default']['wiusvisns_try']});
            $('#wiusvisns-try').css({'opacity': '1'});
        } else {
            $('#wiusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': wius_map_try_config[id]['upclr'], 'stroke': wius_map_try_config['default']['wiusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (wius_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $wiusmtip = $('#tipwiusmap-try');
                            let wiusmaptipw = $wiusmtip.outerWidth(),
                                wiusmaptiph = $wiusmtip.outerHeight();

                            x = (x + wiusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - wiusmaptipw - (20 * 2) : x
                            y = (y + wiusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - wiusmaptiph - 10 : y

                            if (wius_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': wius_map_try_config[id]['dwnclr']});
                            }
                            $wiusmtip.show().html(wius_map_try_config[id]['hover']);
                            $wiusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': wius_map_try_config[id]['upclr']});
                            if (wius_map_try_config[id]['targt'] === '_blank') {
                                window.open(wius_map_try_config[id]['url']);
                            } else if (wius_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = wius_map_try_config[id]['url'];
                            }
                            $('#tipwiusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipwiusmap-try').show().html(wius_map_try_config[id]['hover']);
                _obj.css({'fill': wius_map_try_config[id]['ovrclr']});
                _abb.css({'fill': wius_map_try_config['default']['wiusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipwiusmap-try').hide();
                _obj.css({'fill': wius_map_try_config[id]['upclr']});
                _abb.css({'fill': wius_map_try_config['default']['wiusvisns_try']});
            });
            if (wius_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': wius_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': wius_map_try_config[id]['ovrclr']});
                if (wius_map_try_config[id]['targt'] === '_blank') {
                    window.open(wius_map_try_config[id]['url']);
                } else if (wius_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = wius_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mwius = $('#tipwiusmap-try');
                let wiusmaptipw = $mwius.outerWidth(), wiusmaptiph = $mwius.outerHeight();

                x = (x + wiusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - wiusmaptipw - (20 * 2) : x
                y = (y + wiusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - wiusmaptiph - 10 : y

                $mwius.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
