<?php
/*
Plugin Name: Virginia Map Try
Plugin URI: https://www.wpmapplugins.com/states/interactive-map-of-virginia-wordpress-plugin.html
Description: Customize each county (colors, link, etc) through the map dashboard and use the shortcode in your page.
Version: 2.7
Author: WP Map Plugins
Author URI: https://www.wpmapplugins.com/
Text Domain: vaus-map-try
Domain Path: /languages
*/

declare(strict_types=1);

namespace VAUSMap_TRY;

use VAUSMap_TRY\VAUSMap_TRY;

if (!defined('VAUSMAP_TRY_VERSION')) {
    define('VAUSMAP_TRY_VERSION', '2.7');
}

if (!defined('VAUSMAP_TRY_DIR')) {
    define('VAUSMAP_TRY_DIR', plugin_dir_path(__FILE__));
}

if (!defined('VAUSMAP_TRY_URL')) {
    define('VAUSMAP_TRY_URL', plugin_dir_url(__FILE__));
}

(new VAUSMap_TRY())->init();

class VAUSMap_TRY {

    const PLUGIN_NAME = 'Virginia Map Try';

    private $options = null;

    public function init() {
        $this->initActions();
        $this->initShortcodes();
        $this->initOptions();
    }

    private function initActions() {
        if( !function_exists('wp_get_current_user') ) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        add_action( 'admin_menu', array($this, 'addOptionsPage') );
        add_action( 'admin_footer', array($this, 'addJsConfigInFooter') );
        add_action( 'wp_footer', array($this, 'addSpanTag') );
        add_action( 'admin_enqueue_scripts', array($this, 'initAdminScript') );
        add_action( 'init', array($this, 'loadTextdomain') );
    }

    private function initShortcodes() {
        add_shortcode('vaus_map_try', array($this, 'VAUSMap_TRYShortcode'));
    }

    private function initOptions() {
        $defaultOptions = $this->getDefaultOptions();
        $this->options  = get_option('vaus_map_try');

        if (current_user_can( 'manage_options' )){
            $this->updateOptions($defaultOptions);
        }

        if (!is_array($this->options)) {
            $this->options = $defaultOptions;
        }
    }

    public function addJsConfigInFooter() {
        echo wp_kses_post('<span id="tipvausmap-try" style="margin-top:-32px"></span>');
        include __DIR__ . "/mconfig.php";
    }

    public function addOptionsPage() {
        add_menu_page(
            VAUSMap_TRY::PLUGIN_NAME,
            VAUSMap_TRY::PLUGIN_NAME,
            'manage_options',
            'vaus-map-try',
            array($this, 'optionsScreen'),
            VAUSMAP_TRY_URL . 'public/images/map-icon.png'
        );
    }

    /**
     * @return array
     */
    private function getDefaultOptions() {
        $default = array(
            'vausbrdrclr_try'    => '#6B8B9E',
            'vausshowvisns_try'  => 'Yes',
            'vausvisns_try'      => '#666666',
            'vausvisnshover_try' => '#113e6b',
        );

        return $default;
    }

    private function updateOptions(array $defaultOptions) {

        if (isset($_POST['vaus_map_try']) && !isset($_POST['preview_map'])) {
            update_option('vaus_map_try',$_POST);

            $this->options = $_POST;
        }
    }

    public function VAUSMap_TRYShortcode() {
        wp_enqueue_style('vaus-map-try-style-frontend', VAUSMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');
        wp_enqueue_script('vaus-map-try-interact', VAUSMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);

        ob_start();

        include __DIR__ . "/includes/map.php";
        include __DIR__ . "/mconfig.php";

        return ob_get_clean();
    }

    public function optionsScreen() {
        include __DIR__ . "/includes/admin.php";
    }

    public function initAdminScript() {
        if ( current_user_can( 'manage_options') && ( esc_attr(isset($_GET['page'])) && esc_attr($_GET['page']) == 'vaus-map-try') ):

            wp_enqueue_style('vaus-map-try-dashboard-style', VAUSMAP_TRY_URL . 'public/css/dashboard-style.css', false, '1.0', 'all');
            wp_enqueue_style('vaus-map-try-style', VAUSMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');

            wp_enqueue_script('vaus-map-try-interact', VAUSMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);
        endif;
    }

    public function addSpanTag()
    {
        echo wp_kses_post('<span id="tipvausmap-try"></span>');
    }
    
    public function loadTextdomain() {
        load_plugin_textdomain( 'vaus-map-try', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }
}
