( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"vausmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + vaus_map_try_config[id]['title']);
        var _abb = $('#' + vaus_map_try_config[id]['title']);
        $('#vausmapwrapper-try').css({'opacity': '1'});

        if(vaus_map_try_config['default']['vausshowvisns_try'] == 'Yes') {
            $('#vausvisns-try').css({'fill': vaus_map_try_config['default']['vausvisns_try']});
            $('#vausvisns-try').css({'opacity': '1'});
        } else {
            $('#vausvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': vaus_map_try_config[id]['upColor'], 'stroke': vaus_map_try_config['default']['vausbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (vaus_map_try_config[id]['enble'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $vausmtip = $('#tipvausmap-try');
                            let vausmaptipw = $vausmtip.outerWidth(),
                                vausmaptiph = $vausmtip.outerHeight();

                            x = (x + vausmaptipw > $(document).scrollLeft() + $(window).width()) ? x - vausmaptipw - (20 * 2) : x
                            y = (y + vausmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - vausmaptiph - 10 : y

                            if (vaus_map_try_config[id]['target'] !== 'none') {
                                _obj.css({'fill': vaus_map_try_config[id]['downColor']});
                            }
                            $vausmtip.show().html(vaus_map_try_config[id]['hover']);
                            $vausmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': vaus_map_try_config[id]['upColor']});
                            if (vaus_map_try_config[id]['target'] === 'new') {
                                window.open(vaus_map_try_config[id]['url']);
                            } else if (vaus_map_try_config[id]['target'] === 'self') {
                                window.parent.location.href = vaus_map_try_config[id]['url'];
                            }
                            $('#tipvausmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipvausmap-try').show().html(vaus_map_try_config[id]['hover']);
                _obj.css({'fill': vaus_map_try_config[id]['overColor']});
                _abb.css({'fill': vaus_map_try_config['default']['vausvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipvausmap-try').hide();
                _obj.css({'fill': vaus_map_try_config[id]['upColor']});
                _abb.css({'fill': vaus_map_try_config['default']['vausvisns_try']});
            });
            if (vaus_map_try_config[id]['target'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': vaus_map_try_config[id]['downColor']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': vaus_map_try_config[id]['overColor']});
                if (vaus_map_try_config[id]['target'] === 'new') {
                    window.open(vaus_map_try_config[id]['url']);
                } else if (vaus_map_try_config[id]['target'] === 'self') {
                    window.parent.location.href = vaus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mvaus = $('#tipvausmap-try');
                let vausmaptipw = $mvaus.outerWidth(), vausmaptiph = $mvaus.outerHeight();

                x = (x + vausmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - vausmaptipw - (20 * 2) : x
                y = (y + vausmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - vausmaptiph - 10 : y

                $mvaus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
