( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"uscanadamapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + uscanada_map_try_config[id]['title']);
        var _abb = $('#' + uscanada_map_try_config[id]['title']);
        $('#uscanadamapwrapper-try').css({'opacity': '1'});

        if(uscanada_map_try_config['default']['uscanadashowvisns_try'] === true) {
            $('#uscanadavisns-try').css({'fill': uscanada_map_try_config['default']['uscanadavisns_try']});
            $('#uscanadavisns-try').css({'opacity': '1'});
        } else {
            $('#uscanadavisns-try').css({'opacity': '0'});
        }

        if(uscanada_map_try_config['default']['uscanadashowlakes_try'] === true) {
            $('#uscanadalakes-try path').css({'stroke': uscanada_map_try_config['default']['uscanadabrdrclr_try']});
            $('#uscanadalakes-try').css({'fill': uscanada_map_try_config['default']['uscanadalakesfill_try']});
            $('#uscanadalakes-try').css({'visibility': 'visible'});
        } else {
            $('#uscanadalakes-try').css({'visibility': 'hidden'});
        }


        if(uscanada_map_try_config['default']['uscanadashowdc_try'] === true) {
            $('#uscanadamapvtry_64' + ',' + '#uscanadavnvtry_64').css({'visibility': 'visible'});
        } else {
            $('#uscanadamapvtry_64' + ',' + '#uscanadavnvtry_64').css({'visibility': 'hidden'});
        }

        if(uscanada_map_try_config['default']['uscanadacallouts_try'] === true) {
            $('#uscanadacallouts-try').css({'visibility': 'hidden'});
        } else {
            $('#uscanadacallouts-try').css({'visibility': 'visible'});
        }

        _obj.attr({'fill': uscanada_map_try_config[id]['upclr'], 'stroke': uscanada_map_try_config['default']['uscanadabrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (uscanada_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $uscanadamtip = $('#tipuscanadamap-try');
                            let uscanadamaptipw = $uscanadamtip.outerWidth(),
                                uscanadamaptiph = $uscanadamtip.outerHeight();

                            x = (x + uscanadamaptipw > $(document).scrollLeft() + $(window).width()) ? x - uscanadamaptipw - (20 * 2) : x
                            y = (y + uscanadamaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - uscanadamaptiph - 10 : y

                            if (uscanada_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': uscanada_map_try_config[id]['dwnclr']});
                            }
                            $uscanadamtip.show().html(uscanada_map_try_config[id]['hover']);
                            $uscanadamtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': uscanada_map_try_config[id]['upclr']});
                            if (uscanada_map_try_config[id]['targt'] === '_blank') {
                                window.open(uscanada_map_try_config[id]['url']);
                            } else if (uscanada_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = uscanada_map_try_config[id]['url'];
                            }
                            $('#tipuscanadamap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipuscanadamap-try').show().html(uscanada_map_try_config[id]['hover']);
                _obj.css({'fill': uscanada_map_try_config[id]['ovrclr']});
                _abb.css({'fill': uscanada_map_try_config['default']['uscanadavisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipuscanadamap-try').hide();
                _obj.css({'fill': uscanada_map_try_config[id]['upclr']});
                _abb.css({'fill': uscanada_map_try_config['default']['uscanadavisns_try']});
            });
            if (uscanada_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': uscanada_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': uscanada_map_try_config[id]['ovrclr']});
                if (uscanada_map_try_config[id]['targt'] === '_blank') {
                    window.open(uscanada_map_try_config[id]['url']);
                } else if (uscanada_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = uscanada_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $muscanada = $('#tipuscanadamap-try');
                let uscanadamaptipw = $muscanada.outerWidth(), uscanadamaptiph = $muscanada.outerHeight();

                x = (x + uscanadamaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - uscanadamaptipw - (20 * 2) : x
                y = (y + uscanadamaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - uscanadamaptiph - 10 : y

                $muscanada.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
