( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"uamapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ua_map_try_config[id]['title']);
        var _abb = $('#' + ua_map_try_config[id]['title']);
        $('#uamapwrapper-try').css({'opacity': '1'});

        if(ua_map_try_config['default']['uashowvisns_try'] === true) {
            $('#uavisns-try').css({'fill': ua_map_try_config['default']['uavisns_try']});
            $('#uavisns-try').css({'opacity': '1'});
        } else {
            $('#uavisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ua_map_try_config[id]['upclr'], 'stroke': ua_map_try_config['default']['uabrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ua_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $uamtip = $('#tipuamap-try');
                            let uamaptipw = $uamtip.outerWidth(),
                                uamaptiph = $uamtip.outerHeight();

                            x = (x + uamaptipw > $(document).scrollLeft() + $(window).width()) ? x - uamaptipw - (20 * 2) : x
                            y = (y + uamaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - uamaptiph - 10 : y

                            if (ua_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': ua_map_try_config[id]['dwnclr']});
                            }
                            $uamtip.show().html(ua_map_try_config[id]['hover']);
                            $uamtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ua_map_try_config[id]['upclr']});
                            if (ua_map_try_config[id]['targt'] === '_blank') {
                                window.open(ua_map_try_config[id]['url']);
                            } else if (ua_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = ua_map_try_config[id]['url'];
                            }
                            $('#tipuamap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipuamap-try').show().html(ua_map_try_config[id]['hover']);
                _obj.css({'fill': ua_map_try_config[id]['ovrclr']});
                _abb.css({'fill': ua_map_try_config['default']['uavisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipuamap-try').hide();
                _obj.css({'fill': ua_map_try_config[id]['upclr']});
                _abb.css({'fill': ua_map_try_config['default']['uavisns_try']});
            });
            if (ua_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ua_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ua_map_try_config[id]['ovrclr']});
                if (ua_map_try_config[id]['targt'] === '_blank') {
                    window.open(ua_map_try_config[id]['url']);
                } else if (ua_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = ua_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mua = $('#tipuamap-try');
                let uamaptipw = $mua.outerWidth(), uamaptiph = $mua.outerHeight();

                x = (x + uamaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - uamaptipw - (20 * 2) : x
                y = (y + uamaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - uamaptiph - 10 : y

                $mua.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
