<?php
/*
Plugin Name: Turkey Map Try
Plugin URI: https://www.wpmapplugins.com/interactive-map-of-turkey-wordpress-plugin.html
Description: Customize each province (colors, link, etc) through the map dashboard and use the shortcode in your page.
Version: 2.7
Author: WP Map Plugins
Author URI: https://www.wpmapplugins.com/
Text Domain: tr-map-try
Domain Path: /languages
*/

declare(strict_types=1);

namespace TRMap_TRY;

use TRMap_TRY\TRMap_TRY;

if (!defined('TRMAP_TRY_VERSION')) {
    define('TRMAP_TRY_VERSION', '2.7');
}

if (!defined('TRMAP_TRY_DIR')) {
    define('TRMAP_TRY_DIR', plugin_dir_path(__FILE__));
}

if (!defined('TRMAP_TRY_URL')) {
    define('TRMAP_TRY_URL', plugin_dir_url(__FILE__));
}

(new TRMap_TRY())->init();

class TRMap_TRY {

    const PLUGIN_NAME = 'Turkey Map Try';

    private $options = null;

    public function init() {
        $this->initActions();
        $this->initShortcodes();
        $this->initOptions();
    }

    private function initActions() {
    	if( !function_exists('wp_get_current_user') ) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        add_action( 'admin_menu', array($this, 'addOptionsPage') );
        add_action( 'admin_footer', array($this, 'addJsConfigInFooter') );
        add_action( 'wp_footer', array($this, 'addSpanTag') );
        add_action( 'admin_enqueue_scripts', array($this, 'initAdminScript') );
        add_action( 'init', array($this, 'loadTextdomain') );
    }

    private function initShortcodes() {
        add_shortcode('tr_map_try', array($this, 'TRMap_TRYShortcode'));
    }

    private function initOptions() {
        $defaultOptions = $this->getDefaultOptions();
        $this->options  = get_option('tr_map_try');

        if (current_user_can( 'manage_options' )){
            $this->updateOptions($defaultOptions);
        }

        if (!is_array($this->options)) {
            $this->options = $defaultOptions;
        }

        $this->prepareOptionsListForTpl();
    }

    public function addJsConfigInFooter() {
        echo wp_kses_post('<span id="tiptrmap-try" style="margin-top:-32px"></span>');
        include __DIR__ . "/includes/js-config.php";
    }

    public function addOptionsPage() {
        add_menu_page(
            TRMap_TRY::PLUGIN_NAME,
            TRMap_TRY::PLUGIN_NAME,
            'manage_options',
            'tr-map-try',
            array($this, 'optionsScreen'),
            TRMAP_TRY_URL . 'public/images/map-icon.png'
        );
    }

    /**
     * @return array
     */
    private function getDefaultOptions() {
        $default = array(
            'trbrdrclr_try'    => '#6B8B9E',
            'trshowvisns_try'  => 1,
            'trvisns_try'      => '#666666',
            'trvisnshover_try' => '#113e6b',
        );

        $areas = array(
            'ADANA', 'ADIYAMAN', 'AFYONKARAHISAR', 'AKSARAY', 'AMASYA', 'ANKARA', 'ANTALYA', 'ARDAHAN', 'ARTVIN', 'AYDIN', 'AĞRI', 'BALIKESIR', 'BARTIN', 'BATMAN', 'BAYBURT', 'BILECIK', 'BINGÖL', 'BITLIS', 'BOLU', 'BURDUR', 'BURSA', 'DENIZLI', 'DIYARBAKIR', 'DÜZCE', 'EDIRNE', 'ELAZIĞ', 'ERZINCAN', 'ERZURUM', 'ESKIŞEHIR', 'GAZIANTEP', 'GIRESUN', 'GÜMÜŞHANE', 'HAKKÂRI', 'HATAY', 'ISPARTA', 'ISTANBUL', 'IĞDIR', 'İZMIR', 'KAHRAMANMARAŞ', 'KARABÜK', 'KARAMAN'
        );

        foreach ($areas as $k => $area) {
            $default['upclr_' . ($k + 1)]  = '#E0F3FF';
            $default['ovrclr_' . ($k + 1)] = '#8FBEE8';
            $default['dwnclr_' . ($k + 1)] = '#477CB2';
            $default['url_' . ($k + 1)]    = '';
            $default['turl_' . ($k + 1)]   = '_self';
            $default['info_' . ($k + 1)]   = $area;
            $default['enbl_' . ($k + 1)]   = 1;
        }

        return $default;
    }

    private function updateOptions(array $defaultOptions) {
        if (isset($_POST['tr_map_try']) && isset($_POST['submit-clrs'])) {
            $i = 1;
            while (isset($_POST['url_' . $i])) {
                $_POST['upclr_' . $i]  = $_POST['upclr_all'];
                $_POST['ovrclr_' . $i] = $_POST['ovrclr_all'];
                $_POST['dwnclr_' . $i] = $_POST['dwnclr_all'];

                $i++;
            }

            update_option('tr_map_try',$_POST);

            $this->options = $_POST;
        }

        if (isset($_POST['tr_map_try']) && isset($_POST['submit-url'])) {
            $i = 1;
            while (isset($_POST['url_' . $i])) {
                $_POST['url_' . $i]  = $_POST['url_all'];
                $_POST['turl_' . $i] = $_POST['turl_all'];

                $i++;
            }

            update_option('tr_map_try',$_POST);

            $this->options = $_POST;
        }

        if (isset($_POST['tr_map_try']) && isset($_POST['submit-info'])) {
            $i = 1;
            while (isset($_POST['url_' . $i])) {
                $_POST['info_' . $i] = $_POST['info_all'];

                $i++;
            }

            update_option('tr_map_try',$_POST);

            $this->options = $_POST;
        }

        if (isset($_POST['tr_map_try']) && !isset($_POST['preview_map'])) {
            update_option('tr_map_try',$_POST);

            $this->options = $_POST;
        }

        if (isset($_POST['tr_map_try']) && isset($_POST['restore_default'])) {
            update_option('tr_map_try', $defaultOptions);

            $this->options = $defaultOptions;
        }
    }

    private function prepareOptionsListForTpl() {
        $this->options['prepared_list'] = array();
        $i                              = 1;
        while (isset($this->options['url_' . $i])) {
            $this->options['prepared_list'][] = array(
                'index'  => $i,
                'info_'  => $this->options['info_' . $i],
                'url'    => $this->options['url_' . $i],
                'turl'   => $this->options['turl_' . $i],
                'upclr'  => $this->options['upclr_' . $i],
                'ovrclr' => $this->options['ovrclr_' . $i],
                'dwnclr' => $this->options['dwnclr_' . $i],
                'enbl'   => isset($this->options['enbl_' . $i]),
            );

            $i++;
        }
    }

    public function TRMap_TRYShortcode() {
        wp_enqueue_style('tr-map-try-style-frontend', TRMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');
        wp_enqueue_script('tr-map-try-interact', TRMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);

        ob_start();

        include __DIR__ . "/includes/map.php";
        include __DIR__ . "/includes/js-config.php";

        return ob_get_clean();
    }

    public function optionsScreen() {
        include __DIR__ . "/includes/admin.php";
    }

    public function initAdminScript() {
        if ( current_user_can( 'manage_options') && ( esc_attr(isset($_GET['page'])) && esc_attr($_GET['page']) == 'tr-map-try') ):
            wp_enqueue_style('wp-color-picker');
            wp_enqueue_style('thickbox');
            wp_enqueue_script('thickbox');
            wp_enqueue_script('media-upload');

            wp_enqueue_style('tr-map-try-dashboard-style', TRMAP_TRY_URL . 'public/css/dashboard-style.css', false, '1.0', 'all');
            wp_enqueue_style('tr-map-try-style', TRMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');
            wp_enqueue_style('wp-tinyeditor', TRMAP_TRY_URL . 'public/css/tinyeditor.css', false, '1.0', 'all');

            wp_enqueue_script('tr-map-try-interact', TRMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);
            wp_enqueue_script('tr-map-try-tiny.editor', TRMAP_TRY_URL . 'public/js/editor/tinymce.min.js', 10, '1.0', true);
            wp_enqueue_script('tr-map-try-script', TRMAP_TRY_URL . 'public/js/editor/scripts.js', array('wp-color-picker'), false, true);
        endif;
    }

    public function addSpanTag()
    {
        echo wp_kses_post('<span id="tiptrmap-try"></span>');
    }
    
    public function loadTextdomain() {
        load_plugin_textdomain( 'tr-map-try', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }
}
