( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"trmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + tr_map_try_config[id]['title']);
        var _abb = $('#' + tr_map_try_config[id]['title']);
        $('#trmapwrapper-try').css({'opacity': '1'});

        if(tr_map_try_config['default']['trshowvisns_try'] === true) {
            $('#trvisns-try').css({'fill': tr_map_try_config['default']['trvisns_try']});
            $('#trvisns-try').css({'opacity': '1'});
        } else {
            $('#trvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': tr_map_try_config[id]['upclr'], 'stroke': tr_map_try_config['default']['trbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (tr_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $trmtip = $('#tiptrmap-try');
                            let trmaptipw = $trmtip.outerWidth(),
                                trmaptiph = $trmtip.outerHeight();

                            x = (x + trmaptipw > $(document).scrollLeft() + $(window).width()) ? x - trmaptipw - (20 * 2) : x
                            y = (y + trmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - trmaptiph - 10 : y

                            if (tr_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': tr_map_try_config[id]['dwnclr']});
                            }
                            $trmtip.show().html(tr_map_try_config[id]['hover']);
                            $trmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': tr_map_try_config[id]['upclr']});
                            if (tr_map_try_config[id]['targt'] === '_blank') {
                                window.open(tr_map_try_config[id]['url']);
                            } else if (tr_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = tr_map_try_config[id]['url'];
                            }
                            $('#tiptrmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tiptrmap-try').show().html(tr_map_try_config[id]['hover']);
                _obj.css({'fill': tr_map_try_config[id]['ovrclr']});
                _abb.css({'fill': tr_map_try_config['default']['trvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tiptrmap-try').hide();
                _obj.css({'fill': tr_map_try_config[id]['upclr']});
                _abb.css({'fill': tr_map_try_config['default']['trvisns_try']});
            });
            if (tr_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': tr_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': tr_map_try_config[id]['ovrclr']});
                if (tr_map_try_config[id]['targt'] === '_blank') {
                    window.open(tr_map_try_config[id]['url']);
                } else if (tr_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = tr_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mtr = $('#tiptrmap-try');
                let trmaptipw = $mtr.outerWidth(), trmaptiph = $mtr.outerHeight();

                x = (x + trmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - trmaptipw - (20 * 2) : x
                y = (y + trmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - trmaptiph - 10 : y

                $mtr.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
