( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"tnusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + tnus_map_try_config[id]['title']);
        var _abb = $('#' + tnus_map_try_config[id]['title']);
        $('#tnusmapwrapper-try').css({'opacity': '1'});

        if(tnus_map_try_config['default']['tnusshowvisns_try'] === true) {
            $('#tnusvisns-try').css({'fill': tnus_map_try_config['default']['tnusvisns_try']});
            $('#tnusvisns-try').css({'opacity': '1'});
        } else {
            $('#tnusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': tnus_map_try_config[id]['upclr'], 'stroke': tnus_map_try_config['default']['tnusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (tnus_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $tnusmtip = $('#tiptnusmap-try');
                            let tnusmaptipw = $tnusmtip.outerWidth(),
                                tnusmaptiph = $tnusmtip.outerHeight();

                            x = (x + tnusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - tnusmaptipw - (20 * 2) : x
                            y = (y + tnusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - tnusmaptiph - 10 : y

                            if (tnus_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': tnus_map_try_config[id]['dwnclr']});
                            }
                            $tnusmtip.show().html(tnus_map_try_config[id]['hover']);
                            $tnusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': tnus_map_try_config[id]['upclr']});
                            if (tnus_map_try_config[id]['targt'] === '_blank') {
                                window.open(tnus_map_try_config[id]['url']);
                            } else if (tnus_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = tnus_map_try_config[id]['url'];
                            }
                            $('#tiptnusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tiptnusmap-try').show().html(tnus_map_try_config[id]['hover']);
                _obj.css({'fill': tnus_map_try_config[id]['ovrclr']});
                _abb.css({'fill': tnus_map_try_config['default']['tnusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tiptnusmap-try').hide();
                _obj.css({'fill': tnus_map_try_config[id]['upclr']});
                _abb.css({'fill': tnus_map_try_config['default']['tnusvisns_try']});
            });
            if (tnus_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': tnus_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': tnus_map_try_config[id]['ovrclr']});
                if (tnus_map_try_config[id]['targt'] === '_blank') {
                    window.open(tnus_map_try_config[id]['url']);
                } else if (tnus_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = tnus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mtnus = $('#tiptnusmap-try');
                let tnusmaptipw = $mtnus.outerWidth(), tnusmaptiph = $mtnus.outerHeight();

                x = (x + tnusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - tnusmaptipw - (20 * 2) : x
                y = (y + tnusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - tnusmaptiph - 10 : y

                $mtnus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
