( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"samapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + sa_map_try_config[id]['title']);
        var _abb = $('#' + sa_map_try_config[id]['title']);
        $('#samapwrapper-try').css({'opacity': '1'});

        if(sa_map_try_config['default']['sashowvisns_try'] === true) {
            $('#savisns-try').css({'fill': sa_map_try_config['default']['savisns_try']});
            $('#savisns-try').css({'opacity': '1'});
        } else {
            $('#savisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': sa_map_try_config[id]['upclr'], 'stroke': sa_map_try_config['default']['sabrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (sa_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $samtip = $('#tipsamap-try');
                            let samaptipw = $samtip.outerWidth(),
                                samaptiph = $samtip.outerHeight();

                            x = (x + samaptipw > $(document).scrollLeft() + $(window).width()) ? x - samaptipw - (20 * 2) : x
                            y = (y + samaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - samaptiph - 10 : y

                            if (sa_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': sa_map_try_config[id]['dwnclr']});
                            }
                            $samtip.show().html(sa_map_try_config[id]['hover']);
                            $samtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': sa_map_try_config[id]['upclr']});
                            if (sa_map_try_config[id]['targt'] === '_blank') {
                                window.open(sa_map_try_config[id]['url']);
                            } else if (sa_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = sa_map_try_config[id]['url'];
                            }
                            $('#tipsamap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipsamap-try').show().html(sa_map_try_config[id]['hover']);
                _obj.css({'fill': sa_map_try_config[id]['ovrclr']});
                _abb.css({'fill': sa_map_try_config['default']['savisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipsamap-try').hide();
                _obj.css({'fill': sa_map_try_config[id]['upclr']});
                _abb.css({'fill': sa_map_try_config['default']['savisns_try']});
            });
            if (sa_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': sa_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': sa_map_try_config[id]['ovrclr']});
                if (sa_map_try_config[id]['targt'] === '_blank') {
                    window.open(sa_map_try_config[id]['url']);
                } else if (sa_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = sa_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $msa = $('#tipsamap-try');
                let samaptipw = $msa.outerWidth(), samaptiph = $msa.outerHeight();

                x = (x + samaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - samaptipw - (20 * 2) : x
                y = (y + samaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - samaptiph - 10 : y

                $msa.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
