( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"romapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ro_map_try_config[id]['title']);
        var _abb = $('#' + ro_map_try_config[id]['title']);
        $('#romapwrapper-try').css({'opacity': '1'});

        if(ro_map_try_config['default']['roshowvisns_try'] === true) {
            $('#rovisns-try').css({'fill': ro_map_try_config['default']['rovisns_try']});
            $('#rovisns-try').css({'opacity': '1'});
        } else {
            $('#rovisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ro_map_try_config[id]['upclr'], 'stroke': ro_map_try_config['default']['robrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ro_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $romtip = $('#tipromap-try');
                            let romaptipw = $romtip.outerWidth(),
                                romaptiph = $romtip.outerHeight();

                            x = (x + romaptipw > $(document).scrollLeft() + $(window).width()) ? x - romaptipw - (20 * 2) : x
                            y = (y + romaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - romaptiph - 10 : y

                            if (ro_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': ro_map_try_config[id]['dwnclr']});
                            }
                            $romtip.show().html(ro_map_try_config[id]['hover']);
                            $romtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ro_map_try_config[id]['upclr']});
                            if (ro_map_try_config[id]['targt'] === '_blank') {
                                window.open(ro_map_try_config[id]['url']);
                            } else if (ro_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = ro_map_try_config[id]['url'];
                            }
                            $('#tipromap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipromap-try').show().html(ro_map_try_config[id]['hover']);
                _obj.css({'fill': ro_map_try_config[id]['ovrclr']});
                _abb.css({'fill': ro_map_try_config['default']['rovisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipromap-try').hide();
                _obj.css({'fill': ro_map_try_config[id]['upclr']});
                _abb.css({'fill': ro_map_try_config['default']['rovisns_try']});
            });
            if (ro_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ro_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ro_map_try_config[id]['ovrclr']});
                if (ro_map_try_config[id]['targt'] === '_blank') {
                    window.open(ro_map_try_config[id]['url']);
                } else if (ro_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = ro_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mro = $('#tipromap-try');
                let romaptipw = $mro.outerWidth(), romaptiph = $mro.outerHeight();

                x = (x + romaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - romaptipw - (20 * 2) : x
                y = (y + romaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - romaptiph - 10 : y

                $mro.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
