( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"okusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + okus_map_try_config[id]['title']);
        var _abb = $('#' + okus_map_try_config[id]['title']);
        $('#okusmapwrapper-try').css({'opacity': '1'});

        if(okus_map_try_config['default']['okusshowvisns_try'] === true) {
            $('#okusvisns-try').css({'fill': okus_map_try_config['default']['okusvisns_try']});
            $('#okusvisns-try').css({'opacity': '1'});
        } else {
            $('#okusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': okus_map_try_config[id]['upclr'], 'stroke': okus_map_try_config['default']['okusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (okus_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $okusmtip = $('#tipokusmap-try');
                            let okusmaptipw = $okusmtip.outerWidth(),
                                okusmaptiph = $okusmtip.outerHeight();

                            x = (x + okusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - okusmaptipw - (20 * 2) : x
                            y = (y + okusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - okusmaptiph - 10 : y

                            if (okus_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': okus_map_try_config[id]['dwnclr']});
                            }
                            $okusmtip.show().html(okus_map_try_config[id]['hover']);
                            $okusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': okus_map_try_config[id]['upclr']});
                            if (okus_map_try_config[id]['targt'] === '_blank') {
                                window.open(okus_map_try_config[id]['url']);
                            } else if (okus_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = okus_map_try_config[id]['url'];
                            }
                            $('#tipokusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipokusmap-try').show().html(okus_map_try_config[id]['hover']);
                _obj.css({'fill': okus_map_try_config[id]['ovrclr']});
                _abb.css({'fill': okus_map_try_config['default']['okusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipokusmap-try').hide();
                _obj.css({'fill': okus_map_try_config[id]['upclr']});
                _abb.css({'fill': okus_map_try_config['default']['okusvisns_try']});
            });
            if (okus_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': okus_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': okus_map_try_config[id]['ovrclr']});
                if (okus_map_try_config[id]['targt'] === '_blank') {
                    window.open(okus_map_try_config[id]['url']);
                } else if (okus_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = okus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mokus = $('#tipokusmap-try');
                let okusmaptipw = $mokus.outerWidth(), okusmaptiph = $mokus.outerHeight();

                x = (x + okusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - okusmaptipw - (20 * 2) : x
                y = (y + okusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - okusmaptiph - 10 : y

                $mokus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
