( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"ohusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ohus_map_try_config[id]['title']);
        var _abb = $('#' + ohus_map_try_config[id]['title']);
        $('#ohusmapwrapper-try').css({'opacity': '1'});

        if(ohus_map_try_config['default']['ohusshowvisns_try'] === true) {
            $('#ohusvisns-try').css({'fill': ohus_map_try_config['default']['ohusvisns_try']});
            $('#ohusvisns-try').css({'opacity': '1'});
        } else {
            $('#ohusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ohus_map_try_config[id]['upclr'], 'stroke': ohus_map_try_config['default']['ohusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ohus_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $ohusmtip = $('#tipohusmap-try');
                            let ohusmaptipw = $ohusmtip.outerWidth(),
                                ohusmaptiph = $ohusmtip.outerHeight();

                            x = (x + ohusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - ohusmaptipw - (20 * 2) : x
                            y = (y + ohusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - ohusmaptiph - 10 : y

                            if (ohus_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': ohus_map_try_config[id]['dwnclr']});
                            }
                            $ohusmtip.show().html(ohus_map_try_config[id]['hover']);
                            $ohusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ohus_map_try_config[id]['upclr']});
                            if (ohus_map_try_config[id]['targt'] === '_blank') {
                                window.open(ohus_map_try_config[id]['url']);
                            } else if (ohus_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = ohus_map_try_config[id]['url'];
                            }
                            $('#tipohusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipohusmap-try').show().html(ohus_map_try_config[id]['hover']);
                _obj.css({'fill': ohus_map_try_config[id]['ovrclr']});
                _abb.css({'fill': ohus_map_try_config['default']['ohusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipohusmap-try').hide();
                _obj.css({'fill': ohus_map_try_config[id]['upclr']});
                _abb.css({'fill': ohus_map_try_config['default']['ohusvisns_try']});
            });
            if (ohus_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ohus_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ohus_map_try_config[id]['ovrclr']});
                if (ohus_map_try_config[id]['targt'] === '_blank') {
                    window.open(ohus_map_try_config[id]['url']);
                } else if (ohus_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = ohus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mohus = $('#tipohusmap-try');
                let ohusmaptipw = $mohus.outerWidth(), ohusmaptiph = $mohus.outerHeight();

                x = (x + ohusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - ohusmaptipw - (20 * 2) : x
                y = (y + ohusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - ohusmaptiph - 10 : y

                $mohus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
