( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"ocmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + oc_map_try_config[id]['title']);
        var _abb = $('#' + oc_map_try_config[id]['title']);
        $('#ocmapwrapper-try').css({'opacity': '1'});

        if(oc_map_try_config['default']['ocshowvisns_try'] === true) {
            $('#ocvisns-try').css({'fill': oc_map_try_config['default']['ocvisns_try']});
            $('#ocvisns-try').css({'opacity': '1'});
        } else {
            $('#ocvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': oc_map_try_config[id]['upclr'], 'stroke': oc_map_try_config['default']['ocbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (oc_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $ocmtip = $('#tipocmap-try');
                            let ocmaptipw = $ocmtip.outerWidth(),
                                ocmaptiph = $ocmtip.outerHeight();

                            x = (x + ocmaptipw > $(document).scrollLeft() + $(window).width()) ? x - ocmaptipw - (20 * 2) : x
                            y = (y + ocmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - ocmaptiph - 10 : y

                            if (oc_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': oc_map_try_config[id]['dwnclr']});
                            }
                            $ocmtip.show().html(oc_map_try_config[id]['hover']);
                            $ocmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': oc_map_try_config[id]['upclr']});
                            if (oc_map_try_config[id]['targt'] === '_blank') {
                                window.open(oc_map_try_config[id]['url']);
                            } else if (oc_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = oc_map_try_config[id]['url'];
                            }
                            $('#tipocmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipocmap-try').show().html(oc_map_try_config[id]['hover']);
                _obj.css({'fill': oc_map_try_config[id]['ovrclr']});
                _abb.css({'fill': oc_map_try_config['default']['ocvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipocmap-try').hide();
                _obj.css({'fill': oc_map_try_config[id]['upclr']});
                _abb.css({'fill': oc_map_try_config['default']['ocvisns_try']});
            });
            if (oc_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': oc_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': oc_map_try_config[id]['ovrclr']});
                if (oc_map_try_config[id]['targt'] === '_blank') {
                    window.open(oc_map_try_config[id]['url']);
                } else if (oc_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = oc_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $moc = $('#tipocmap-try');
                let ocmaptipw = $moc.outerWidth(), ocmaptiph = $moc.outerHeight();

                x = (x + ocmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - ocmaptipw - (20 * 2) : x
                y = (y + ocmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - ocmaptiph - 10 : y

                $moc.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
