( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"nyusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + nyus_map_try_config[id]['title']);
        var _abb = $('#' + nyus_map_try_config[id]['title']);
        $('#nyusmapwrapper-try').css({'opacity': '1'});

        if(nyus_map_try_config['default']['nyusshowvisns_try'] === true) {
            $('#nyusvisns-try').css({'fill': nyus_map_try_config['default']['nyusvisns_try']});
            $('#nyusvisns-try').css({'opacity': '1'});
        } else {
            $('#nyusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': nyus_map_try_config[id]['upclr'], 'stroke': nyus_map_try_config['default']['nyusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (nyus_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $nyusmtip = $('#tipnyusmap-try');
                            let nyusmaptipw = $nyusmtip.outerWidth(),
                                nyusmaptiph = $nyusmtip.outerHeight();

                            x = (x + nyusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - nyusmaptipw - (20 * 2) : x
                            y = (y + nyusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - nyusmaptiph - 10 : y

                            if (nyus_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': nyus_map_try_config[id]['dwnclr']});
                            }
                            $nyusmtip.show().html(nyus_map_try_config[id]['hover']);
                            $nyusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': nyus_map_try_config[id]['upclr']});
                            if (nyus_map_try_config[id]['targt'] === '_blank') {
                                window.open(nyus_map_try_config[id]['url']);
                            } else if (nyus_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = nyus_map_try_config[id]['url'];
                            }
                            $('#tipnyusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipnyusmap-try').show().html(nyus_map_try_config[id]['hover']);
                _obj.css({'fill': nyus_map_try_config[id]['ovrclr']});
                _abb.css({'fill': nyus_map_try_config['default']['nyusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipnyusmap-try').hide();
                _obj.css({'fill': nyus_map_try_config[id]['upclr']});
                _abb.css({'fill': nyus_map_try_config['default']['nyusvisns_try']});
            });
            if (nyus_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': nyus_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': nyus_map_try_config[id]['ovrclr']});
                if (nyus_map_try_config[id]['targt'] === '_blank') {
                    window.open(nyus_map_try_config[id]['url']);
                } else if (nyus_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = nyus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mnyus = $('#tipnyusmap-try');
                let nyusmaptipw = $mnyus.outerWidth(), nyusmaptiph = $mnyus.outerHeight();

                x = (x + nyusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - nyusmaptipw - (20 * 2) : x
                y = (y + nyusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - nyusmaptiph - 10 : y

                $mnyus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
