( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"nmusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + nmus_map_try_config[id]['title']);
        var _abb = $('#' + nmus_map_try_config[id]['title']);
        $('#nmusmapwrapper-try').css({'opacity': '1'});

        if(nmus_map_try_config['default']['nmusshowvisns_try'] === true) {
            $('#nmusvisns-try').css({'fill': nmus_map_try_config['default']['nmusvisns_try']});
            $('#nmusvisns-try').css({'opacity': '1'});
        } else {
            $('#nmusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': nmus_map_try_config[id]['upclr'], 'stroke': nmus_map_try_config['default']['nmusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (nmus_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $nmusmtip = $('#tipnmusmap-try');
                            let nmusmaptipw = $nmusmtip.outerWidth(),
                                nmusmaptiph = $nmusmtip.outerHeight();

                            x = (x + nmusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - nmusmaptipw - (20 * 2) : x
                            y = (y + nmusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - nmusmaptiph - 10 : y

                            if (nmus_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': nmus_map_try_config[id]['dwnclr']});
                            }
                            $nmusmtip.show().html(nmus_map_try_config[id]['hover']);
                            $nmusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': nmus_map_try_config[id]['upclr']});
                            if (nmus_map_try_config[id]['targt'] === '_blank') {
                                window.open(nmus_map_try_config[id]['url']);
                            } else if (nmus_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = nmus_map_try_config[id]['url'];
                            }
                            $('#tipnmusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipnmusmap-try').show().html(nmus_map_try_config[id]['hover']);
                _obj.css({'fill': nmus_map_try_config[id]['ovrclr']});
                _abb.css({'fill': nmus_map_try_config['default']['nmusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipnmusmap-try').hide();
                _obj.css({'fill': nmus_map_try_config[id]['upclr']});
                _abb.css({'fill': nmus_map_try_config['default']['nmusvisns_try']});
            });
            if (nmus_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': nmus_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': nmus_map_try_config[id]['ovrclr']});
                if (nmus_map_try_config[id]['targt'] === '_blank') {
                    window.open(nmus_map_try_config[id]['url']);
                } else if (nmus_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = nmus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mnmus = $('#tipnmusmap-try');
                let nmusmaptipw = $mnmus.outerWidth(), nmusmaptiph = $mnmus.outerHeight();

                x = (x + nmusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - nmusmaptipw - (20 * 2) : x
                y = (y + nmusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - nmusmaptiph - 10 : y

                $mnmus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
