( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"ncusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ncus_map_try_config[id]['title']);
        var _abb = $('#' + ncus_map_try_config[id]['title']);
        $('#ncusmapwrapper-try').css({'opacity': '1'});

        if(ncus_map_try_config['default']['ncusshowvisns_try'] == 'Yes') {
            $('#ncusvisns-try').css({'fill': ncus_map_try_config['default']['ncusvisns_try']});
            $('#ncusvisns-try').css({'opacity': '1'});
        } else {
            $('#ncusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ncus_map_try_config[id]['upColor'], 'stroke': ncus_map_try_config['default']['ncusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ncus_map_try_config[id]['enble'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $ncusmtip = $('#tipncusmap-try');
                            let ncusmaptipw = $ncusmtip.outerWidth(),
                                ncusmaptiph = $ncusmtip.outerHeight();

                            x = (x + ncusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - ncusmaptipw - (20 * 2) : x
                            y = (y + ncusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - ncusmaptiph - 10 : y

                            if (ncus_map_try_config[id]['target'] !== 'none') {
                                _obj.css({'fill': ncus_map_try_config[id]['downColor']});
                            }
                            $ncusmtip.show().html(ncus_map_try_config[id]['hover']);
                            $ncusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ncus_map_try_config[id]['upColor']});
                            if (ncus_map_try_config[id]['target'] === 'new') {
                                window.open(ncus_map_try_config[id]['url']);
                            } else if (ncus_map_try_config[id]['target'] === 'self') {
                                window.parent.location.href = ncus_map_try_config[id]['url'];
                            }
                            $('#tipncusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipncusmap-try').show().html(ncus_map_try_config[id]['hover']);
                _obj.css({'fill': ncus_map_try_config[id]['overColor']});
                _abb.css({'fill': ncus_map_try_config['default']['ncusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipncusmap-try').hide();
                _obj.css({'fill': ncus_map_try_config[id]['upColor']});
                _abb.css({'fill': ncus_map_try_config['default']['ncusvisns_try']});
            });
            if (ncus_map_try_config[id]['target'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ncus_map_try_config[id]['downColor']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ncus_map_try_config[id]['overColor']});
                if (ncus_map_try_config[id]['target'] === 'new') {
                    window.open(ncus_map_try_config[id]['url']);
                } else if (ncus_map_try_config[id]['target'] === 'self') {
                    window.parent.location.href = ncus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mncus = $('#tipncusmap-try');
                let ncusmaptipw = $mncus.outerWidth(), ncusmaptiph = $mncus.outerHeight();

                x = (x + ncusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - ncusmaptipw - (20 * 2) : x
                y = (y + ncusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - ncusmaptiph - 10 : y

                $mncus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
