<?php
/*
Plugin Name: North Carolina Map Try
Plugin URI: https://www.wpmapplugins.com/states/interactive-map-of-north-carolina-wordpress-plugin.html
Description: Customize each county (colors, link, etc) through the map dashboard and use the shortcode in your page.
Version: 2.7
Author: WP Map Plugins
Author URI: https://www.wpmapplugins.com/
Text Domain: ncus-map-try
Domain Path: /languages
*/

declare(strict_types=1);

namespace NCUSMap_TRY;

use NCUSMap_TRY\NCUSMap_TRY;

if (!defined('NCUSMAP_TRY_VERSION')) {
    define('NCUSMAP_TRY_VERSION', '2.7');
}

if (!defined('NCUSMAP_TRY_DIR')) {
    define('NCUSMAP_TRY_DIR', plugin_dir_path(__FILE__));
}

if (!defined('NCUSMAP_TRY_URL')) {
    define('NCUSMAP_TRY_URL', plugin_dir_url(__FILE__));
}

(new NCUSMap_TRY())->init();

class NCUSMap_TRY {

    const PLUGIN_NAME = 'North Carolina Map Try';

    private $options = null;

    public function init() {
        $this->initActions();
        $this->initShortcodes();
        $this->initOptions();
    }

    private function initActions() {
        if( !function_exists('wp_get_current_user') ) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        add_action( 'admin_menu', array($this, 'addOptionsPage') );
        add_action( 'admin_footer', array($this, 'addJsConfigInFooter') );
        add_action( 'wp_footer', array($this, 'addSpanTag') );
        add_action( 'admin_enqueue_scripts', array($this, 'initAdminScript') );
        add_action( 'init', array($this, 'loadTextdomain') );
    }

    private function initShortcodes() {
        add_shortcode('ncus_map_try', array($this, 'NCUSMap_TRYShortcode'));
    }

    private function initOptions() {
        $defaultOptions = $this->getDefaultOptions();
        $this->options  = get_option('ncus_map_try');

        if (current_user_can( 'manage_options' )){
            $this->updateOptions($defaultOptions);
        }

        if (!is_array($this->options)) {
            $this->options = $defaultOptions;
        }
    }

    public function addJsConfigInFooter() {
        echo wp_kses_post('<span id="tipncusmap-try" style="margin-top:-32px"></span>');
        include __DIR__ . "/mconfig.php";
    }

    public function addOptionsPage() {
        add_menu_page(
            NCUSMap_TRY::PLUGIN_NAME,
            NCUSMap_TRY::PLUGIN_NAME,
            'manage_options',
            'ncus-map-try',
            array($this, 'optionsScreen'),
            NCUSMAP_TRY_URL . 'public/images/map-icon.png'
        );
    }

    /**
     * @return array
     */
    private function getDefaultOptions() {
        $default = array(
            'ncusbrdrclr_try'    => '#6B8B9E',
            'ncusshowvisns_try'  => 'Yes',
            'ncusvisns_try'      => '#666666',
            'ncusvisnshover_try' => '#113e6b',
        );

        return $default;
    }

    private function updateOptions(array $defaultOptions) {

        if (isset($_POST['ncus_map_try']) && !isset($_POST['preview_map'])) {
            update_option('ncus_map_try',$_POST);

            $this->options = $_POST;
        }
    }

    public function NCUSMap_TRYShortcode() {
        wp_enqueue_style('ncus-map-try-style-frontend', NCUSMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');
        wp_enqueue_script('ncus-map-try-interact', NCUSMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);

        ob_start();

        include __DIR__ . "/includes/map.php";
        include __DIR__ . "/mconfig.php";

        return ob_get_clean();
    }

    public function optionsScreen() {
        include __DIR__ . "/includes/admin.php";
    }

    public function initAdminScript() {
        if ( current_user_can( 'manage_options') && ( esc_attr(isset($_GET['page'])) && esc_attr($_GET['page']) == 'ncus-map-try') ):

            wp_enqueue_style('ncus-map-try-dashboard-style', NCUSMAP_TRY_URL . 'public/css/dashboard-style.css', false, '1.0', 'all');
            wp_enqueue_style('ncus-map-try-style', NCUSMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');

            wp_enqueue_script('ncus-map-try-interact', NCUSMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);
        endif;
    }

    public function addSpanTag()
    {
        echo wp_kses_post('<span id="tipncusmap-try"></span>');
    }
    
    public function loadTextdomain() {
        load_plugin_textdomain( 'ncus-map-try', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }
}
