<?php $ncus_map_try = $this->options; ?>

<form method="post" action="<?php echo esc_url(admin_url('/')); ?>admin.php?page=ncus-map-try">
<div id="map-admin">

  <div id="map-header">
    <p class="map-shortcode"><?php esc_html_e( 'Insert this shortcode ', 'ncus-map-try' ); ?><input type="text" value="[ncus_map_try]" readonly> <?php esc_html_e( 'in any page or post to display the map.', 'ncus-map-try' ); ?> &nbsp; | &nbsp; <span class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_html_e( 'Save Changes', 'ncus-map-try' ); ?>"></span></p>
    <p class="map-sample">This is a free trial version of the map, featuring a selection of clickable counties with full access to all premium features. To unlock the complete map, simply upgrade to the <a href="<?php echo esc_url('https://www.wpmapplugins.com/states/interactive-map-of-north-carolina-wordpress-plugin.html'); ?>">Premium Map of North Carolina</a>.</p>
  </div>

  <div id="map-page">

    <div class="map-col-lt">
      <div id="map-preview">
        <?php include 'map.php'; ?>
      </div>
    </div><!-- map-col-lt -->

    <!-- General Map Colors -->
    <div class="map-col-rt">
      <div class="map-settings">
        <div class="box-header shape-icon"><?php esc_html_e( 'General Settings', 'ncus-map-try' ); ?></div>
        <div class="box-body">
          <div class="general-box"><span class="general-set i-border"><?php esc_html_e( 'Border Color', 'ncus-map-try' ); ?></span>
            <input type="text" name="ncusbrdrclr_try" value="<?php echo esc_attr($ncus_map_try['ncusbrdrclr_try']); ?>" class="color-field" />
          </div>
          <div class="general-box"><span class="general-set i-show-hide"><?php esc_html_e( 'Show the Names?', 'ncus-map-try' ); ?></span>
            <input type="text" name="ncusshowvisns_try" value="<?php echo esc_attr($ncus_map_try['ncusshowvisns_try']); ?>" class="color-field" />
          </div>
          <div class="general-box"><span class="general-set i-abbs"><?php esc_html_e( 'Names Color', 'ncus-map-try' ); ?></span>
            <input type="text" name="ncusvisns_try" value="<?php echo esc_attr($ncus_map_try['ncusvisns_try']); ?>" class="color-field" />
          </div>
          <div class="general-box"><span class="general-set i-abbs"><?php esc_html_e( 'Names Hover Color', 'ncus-map-try' ); ?></span>
            <input type="text" name="ncusvisnshover_try" value="<?php echo esc_attr($ncus_map_try['ncusvisnshover_try']); ?>" class="color-field" />
          </div>
        </div><!-- box-body -->
      </div><!-- map-settings -->
      <p><strong>Need help or custom adjustments?<br><a href="<?php echo esc_url( 'https://www.wpmapplugins.com/assets/contact.html' ); ?>">Contact Us</a>.</strong></p>
    </div><!-- map-col-rt -->

  </div><!-- map-page -->

  <div class="map-settings areas-settings">
    <div class="box-header individ-i"><?php esc_html_e( 'How to customize the counties?', 'ncus-map-try' ); ?></div>
    <div class="box-body goconfig">
      <p>North Carolina is divided into 100+ counties and that's a huge number for WordPress to be customized through a visual editor. As noted in the plugin description you can achieve the same result by direct customization of the plugin file <strong>'mconfig.php'</strong>, you don't need PHP or JavaScript knowledge to edit that file.</p>
      <p>You can access and edit the file 'mconfig.php' either through FTP or directly from your WordPress admin panel by the following steps:
        <ol>
          <li>Go to '<strong>Tools</strong>' > '<strong>Plugin File Editor</strong>'.</li>
          <li>In the right side dropdown menu choose '<strong>North Carolina Map Try</strong>', and click '<strong>select</strong>'.</li>
          <li>Click on this file '<strong>mconfig.php</strong>' to open the editor.</li>
          <li>Make your required edits of colors, links, information, etc then click '<strong>Update File</strong>'.</li>
        </ol>
      </p>
      <p>Please watch this short <a href="<?php echo sanitize_url('https://youtu.be/Cr3lr4xhBBI') ?>">video</a> tutorial for more information, and feel free to <a href="<?php echo sanitize_url('https://www.wpmapplugins.com/assets/contact.html') ?>">contact</a> us if you have any questions.</p>
    </div><!-- box-body / for areas -->
  </div><!-- map-settings / for areas -->

  <input type="hidden" name="ncus_map_try">
  <?php
  settings_fields(__FILE__);
  do_settings_sections(__FILE__);
  ?>

</div><!-- map-admin -->
</form>
