( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"namapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + na_map_try_config[id]['title']);
        var _abb = $('#' + na_map_try_config[id]['title']);
        $('#namapwrapper-try').css({'opacity': '1'});

        if(na_map_try_config['default']['nashowvisns_try'] === true) {
            $('#navisns-try').css({'fill': na_map_try_config['default']['navisns_try']});
            $('#navisns-try').css({'opacity': '1'});
        } else {
            $('#navisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': na_map_try_config[id]['upclr'], 'stroke': na_map_try_config['default']['nabrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (na_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $namtip = $('#tipnamap-try');
                            let namaptipw = $namtip.outerWidth(),
                                namaptiph = $namtip.outerHeight();

                            x = (x + namaptipw > $(document).scrollLeft() + $(window).width()) ? x - namaptipw - (20 * 2) : x
                            y = (y + namaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - namaptiph - 10 : y

                            if (na_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': na_map_try_config[id]['dwnclr']});
                            }
                            $namtip.show().html(na_map_try_config[id]['hover']);
                            $namtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': na_map_try_config[id]['upclr']});
                            if (na_map_try_config[id]['targt'] === '_blank') {
                                window.open(na_map_try_config[id]['url']);
                            } else if (na_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = na_map_try_config[id]['url'];
                            }
                            $('#tipnamap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipnamap-try').show().html(na_map_try_config[id]['hover']);
                _obj.css({'fill': na_map_try_config[id]['ovrclr']});
                _abb.css({'fill': na_map_try_config['default']['navisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipnamap-try').hide();
                _obj.css({'fill': na_map_try_config[id]['upclr']});
                _abb.css({'fill': na_map_try_config['default']['navisns_try']});
            });
            if (na_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': na_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': na_map_try_config[id]['ovrclr']});
                if (na_map_try_config[id]['targt'] === '_blank') {
                    window.open(na_map_try_config[id]['url']);
                } else if (na_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = na_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mna = $('#tipnamap-try');
                let namaptipw = $mna.outerWidth(), namaptiph = $mna.outerHeight();

                x = (x + namaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - namaptipw - (20 * 2) : x
                y = (y + namaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - namaptiph - 10 : y

                $mna.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
