( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"kyusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + kyus_map_try_config[id]['title']);
        var _abb = $('#' + kyus_map_try_config[id]['title']);
        $('#kyusmapwrapper-try').css({'opacity': '1'});

        if(kyus_map_try_config['default']['kyusshowvisns_try'] == 'Yes') {
            $('#kyusvisns-try').css({'fill': kyus_map_try_config['default']['kyusvisns_try']});
            $('#kyusvisns-try').css({'opacity': '1'});
        } else {
            $('#kyusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': kyus_map_try_config[id]['upColor'], 'stroke': kyus_map_try_config['default']['kyusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (kyus_map_try_config[id]['enble'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $kyusmtip = $('#tipkyusmap-try');
                            let kyusmaptipw = $kyusmtip.outerWidth(),
                                kyusmaptiph = $kyusmtip.outerHeight();

                            x = (x + kyusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - kyusmaptipw - (20 * 2) : x
                            y = (y + kyusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - kyusmaptiph - 10 : y

                            if (kyus_map_try_config[id]['target'] !== 'none') {
                                _obj.css({'fill': kyus_map_try_config[id]['downColor']});
                            }
                            $kyusmtip.show().html(kyus_map_try_config[id]['hover']);
                            $kyusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': kyus_map_try_config[id]['upColor']});
                            if (kyus_map_try_config[id]['target'] === 'new') {
                                window.open(kyus_map_try_config[id]['url']);
                            } else if (kyus_map_try_config[id]['target'] === 'self') {
                                window.parent.location.href = kyus_map_try_config[id]['url'];
                            }
                            $('#tipkyusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipkyusmap-try').show().html(kyus_map_try_config[id]['hover']);
                _obj.css({'fill': kyus_map_try_config[id]['overColor']});
                _abb.css({'fill': kyus_map_try_config['default']['kyusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipkyusmap-try').hide();
                _obj.css({'fill': kyus_map_try_config[id]['upColor']});
                _abb.css({'fill': kyus_map_try_config['default']['kyusvisns_try']});
            });
            if (kyus_map_try_config[id]['target'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': kyus_map_try_config[id]['downColor']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': kyus_map_try_config[id]['overColor']});
                if (kyus_map_try_config[id]['target'] === 'new') {
                    window.open(kyus_map_try_config[id]['url']);
                } else if (kyus_map_try_config[id]['target'] === 'self') {
                    window.parent.location.href = kyus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mkyus = $('#tipkyusmap-try');
                let kyusmaptipw = $mkyus.outerWidth(), kyusmaptiph = $mkyus.outerHeight();

                x = (x + kyusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - kyusmaptipw - (20 * 2) : x
                y = (y + kyusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - kyusmaptiph - 10 : y

                $mkyus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
