<?php
/*
Plugin Name: Kentucky Map Try
Plugin URI: https://www.wpmapplugins.com/states/interactive-map-of-kentucky-wordpress-plugin.html
Description: Customize each county (colors, link, etc) through the map dashboard and use the shortcode in your page.
Version: 2.7
Author: WP Map Plugins
Author URI: https://www.wpmapplugins.com/
Text Domain: kyus-map-try
Domain Path: /languages
*/

declare(strict_types=1);

namespace KYUSMap_TRY;

use KYUSMap_TRY\KYUSMap_TRY;

if (!defined('KYUSMAP_TRY_VERSION')) {
    define('KYUSMAP_TRY_VERSION', '2.7');
}

if (!defined('KYUSMAP_TRY_DIR')) {
    define('KYUSMAP_TRY_DIR', plugin_dir_path(__FILE__));
}

if (!defined('KYUSMAP_TRY_URL')) {
    define('KYUSMAP_TRY_URL', plugin_dir_url(__FILE__));
}

(new KYUSMap_TRY())->init();

class KYUSMap_TRY {

    const PLUGIN_NAME = 'Kentucky Map Try';

    private $options = null;

    public function init() {
        $this->initActions();
        $this->initShortcodes();
        $this->initOptions();
    }

    private function initActions() {
        if( !function_exists('wp_get_current_user') ) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        add_action( 'admin_menu', array($this, 'addOptionsPage') );
        add_action( 'admin_footer', array($this, 'addJsConfigInFooter') );
        add_action( 'wp_footer', array($this, 'addSpanTag') );
        add_action( 'admin_enqueue_scripts', array($this, 'initAdminScript') );
        add_action( 'init', array($this, 'loadTextdomain') );
    }

    private function initShortcodes() {
        add_shortcode('kyus_map_try', array($this, 'KYUSMap_TRYShortcode'));
    }

    private function initOptions() {
        $defaultOptions = $this->getDefaultOptions();
        $this->options  = get_option('kyus_map_try');

        if (current_user_can( 'manage_options' )){
            $this->updateOptions($defaultOptions);
        }

        if (!is_array($this->options)) {
            $this->options = $defaultOptions;
        }
    }

    public function addJsConfigInFooter() {
        echo wp_kses_post('<span id="tipkyusmap-try" style="margin-top:-32px"></span>');
        include __DIR__ . "/mconfig.php";
    }

    public function addOptionsPage() {
        add_menu_page(
            KYUSMap_TRY::PLUGIN_NAME,
            KYUSMap_TRY::PLUGIN_NAME,
            'manage_options',
            'kyus-map-try',
            array($this, 'optionsScreen'),
            KYUSMAP_TRY_URL . 'public/images/map-icon.png'
        );
    }

    /**
     * @return array
     */
    private function getDefaultOptions() {
        $default = array(
            'kyusbrdrclr_try'    => '#6B8B9E',
            'kyusshowvisns_try'  => 'Yes',
            'kyusvisns_try'      => '#666666',
            'kyusvisnshover_try' => '#113e6b',
        );

        return $default;
    }

    private function updateOptions(array $defaultOptions) {

        if (isset($_POST['kyus_map_try']) && !isset($_POST['preview_map'])) {
            update_option('kyus_map_try',$_POST);

            $this->options = $_POST;
        }
    }

    public function KYUSMap_TRYShortcode() {
        wp_enqueue_style('kyus-map-try-style-frontend', KYUSMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');
        wp_enqueue_script('kyus-map-try-interact', KYUSMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);

        ob_start();

        include __DIR__ . "/includes/map.php";
        include __DIR__ . "/mconfig.php";

        return ob_get_clean();
    }

    public function optionsScreen() {
        include __DIR__ . "/includes/admin.php";
    }

    public function initAdminScript() {
        if ( current_user_can( 'manage_options') && ( esc_attr(isset($_GET['page'])) && esc_attr($_GET['page']) == 'kyus-map-try') ):

            wp_enqueue_style('kyus-map-try-dashboard-style', KYUSMAP_TRY_URL . 'public/css/dashboard-style.css', false, '1.0', 'all');
            wp_enqueue_style('kyus-map-try-style', KYUSMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');

            wp_enqueue_script('kyus-map-try-interact', KYUSMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);
        endif;
    }

    public function addSpanTag()
    {
        echo wp_kses_post('<span id="tipkyusmap-try"></span>');
    }
    
    public function loadTextdomain() {
        load_plugin_textdomain( 'kyus-map-try', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }
}
