( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"ksusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ksus_map_try_config[id]['title']);
        var _abb = $('#' + ksus_map_try_config[id]['title']);
        $('#ksusmapwrapper-try').css({'opacity': '1'});

        if(ksus_map_try_config['default']['ksusshowvisns_try'] == 'Yes') {
            $('#ksusvisns-try').css({'fill': ksus_map_try_config['default']['ksusvisns_try']});
            $('#ksusvisns-try').css({'opacity': '1'});
        } else {
            $('#ksusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ksus_map_try_config[id]['upColor'], 'stroke': ksus_map_try_config['default']['ksusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ksus_map_try_config[id]['enble'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $ksusmtip = $('#tipksusmap-try');
                            let ksusmaptipw = $ksusmtip.outerWidth(),
                                ksusmaptiph = $ksusmtip.outerHeight();

                            x = (x + ksusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - ksusmaptipw - (20 * 2) : x
                            y = (y + ksusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - ksusmaptiph - 10 : y

                            if (ksus_map_try_config[id]['target'] !== 'none') {
                                _obj.css({'fill': ksus_map_try_config[id]['downColor']});
                            }
                            $ksusmtip.show().html(ksus_map_try_config[id]['hover']);
                            $ksusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ksus_map_try_config[id]['upColor']});
                            if (ksus_map_try_config[id]['target'] === 'new') {
                                window.open(ksus_map_try_config[id]['url']);
                            } else if (ksus_map_try_config[id]['target'] === 'self') {
                                window.parent.location.href = ksus_map_try_config[id]['url'];
                            }
                            $('#tipksusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipksusmap-try').show().html(ksus_map_try_config[id]['hover']);
                _obj.css({'fill': ksus_map_try_config[id]['overColor']});
                _abb.css({'fill': ksus_map_try_config['default']['ksusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipksusmap-try').hide();
                _obj.css({'fill': ksus_map_try_config[id]['upColor']});
                _abb.css({'fill': ksus_map_try_config['default']['ksusvisns_try']});
            });
            if (ksus_map_try_config[id]['target'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ksus_map_try_config[id]['downColor']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ksus_map_try_config[id]['overColor']});
                if (ksus_map_try_config[id]['target'] === 'new') {
                    window.open(ksus_map_try_config[id]['url']);
                } else if (ksus_map_try_config[id]['target'] === 'self') {
                    window.parent.location.href = ksus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mksus = $('#tipksusmap-try');
                let ksusmaptipw = $mksus.outerWidth(), ksusmaptiph = $mksus.outerHeight();

                x = (x + ksusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - ksusmaptipw - (20 * 2) : x
                y = (y + ksusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - ksusmaptiph - 10 : y

                $mksus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
