<?php
/*
Plugin Name: Kansas Map Try
Plugin URI: https://www.wpmapplugins.com/states/interactive-map-of-kansas-wordpress-plugin.html
Description: Customize each county (colors, link, etc) through the map dashboard and use the shortcode in your page.
Version: 2.7
Author: WP Map Plugins
Author URI: https://www.wpmapplugins.com/
Text Domain: ksus-map-try
Domain Path: /languages
*/

declare(strict_types=1);

namespace KSUSMap_TRY;

use KSUSMap_TRY\KSUSMap_TRY;

if (!defined('KSUSMAP_TRY_VERSION')) {
    define('KSUSMAP_TRY_VERSION', '2.7');
}

if (!defined('KSUSMAP_TRY_DIR')) {
    define('KSUSMAP_TRY_DIR', plugin_dir_path(__FILE__));
}

if (!defined('KSUSMAP_TRY_URL')) {
    define('KSUSMAP_TRY_URL', plugin_dir_url(__FILE__));
}

(new KSUSMap_TRY())->init();

class KSUSMap_TRY {

    const PLUGIN_NAME = 'Kansas Map Try';

    private $options = null;

    public function init() {
        $this->initActions();
        $this->initShortcodes();
        $this->initOptions();
    }

    private function initActions() {
        if( !function_exists('wp_get_current_user') ) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        add_action( 'admin_menu', array($this, 'addOptionsPage') );
        add_action( 'admin_footer', array($this, 'addJsConfigInFooter') );
        add_action( 'wp_footer', array($this, 'addSpanTag') );
        add_action( 'admin_enqueue_scripts', array($this, 'initAdminScript') );
        add_action( 'init', array($this, 'loadTextdomain') );
    }

    private function initShortcodes() {
        add_shortcode('ksus_map_try', array($this, 'KSUSMap_TRYShortcode'));
    }

    private function initOptions() {
        $defaultOptions = $this->getDefaultOptions();
        $this->options  = get_option('ksus_map_try');

        if (current_user_can( 'manage_options' )){
            $this->updateOptions($defaultOptions);
        }

        if (!is_array($this->options)) {
            $this->options = $defaultOptions;
        }
    }

    public function addJsConfigInFooter() {
        echo wp_kses_post('<span id="tipksusmap-try" style="margin-top:-32px"></span>');
        include __DIR__ . "/mconfig.php";
    }

    public function addOptionsPage() {
        add_menu_page(
            KSUSMap_TRY::PLUGIN_NAME,
            KSUSMap_TRY::PLUGIN_NAME,
            'manage_options',
            'ksus-map-try',
            array($this, 'optionsScreen'),
            KSUSMAP_TRY_URL . 'public/images/map-icon.png'
        );
    }

    /**
     * @return array
     */
    private function getDefaultOptions() {
        $default = array(
            'ksusbrdrclr_try'    => '#6B8B9E',
            'ksusshowvisns_try'  => 'Yes',
            'ksusvisns_try'      => '#666666',
            'ksusvisnshover_try' => '#113e6b',
        );

        return $default;
    }

    private function updateOptions(array $defaultOptions) {

        if (isset($_POST['ksus_map_try']) && !isset($_POST['preview_map'])) {
            update_option('ksus_map_try',$_POST);

            $this->options = $_POST;
        }
    }

    public function KSUSMap_TRYShortcode() {
        wp_enqueue_style('ksus-map-try-style-frontend', KSUSMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');
        wp_enqueue_script('ksus-map-try-interact', KSUSMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);

        ob_start();

        include __DIR__ . "/includes/map.php";
        include __DIR__ . "/mconfig.php";

        return ob_get_clean();
    }

    public function optionsScreen() {
        include __DIR__ . "/includes/admin.php";
    }

    public function initAdminScript() {
        if ( current_user_can( 'manage_options') && ( esc_attr(isset($_GET['page'])) && esc_attr($_GET['page']) == 'ksus-map-try') ):

            wp_enqueue_style('ksus-map-try-dashboard-style', KSUSMAP_TRY_URL . 'public/css/dashboard-style.css', false, '1.0', 'all');
            wp_enqueue_style('ksus-map-try-style', KSUSMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');

            wp_enqueue_script('ksus-map-try-interact', KSUSMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);
        endif;
    }

    public function addSpanTag()
    {
        echo wp_kses_post('<span id="tipksusmap-try"></span>');
    }
    
    public function loadTextdomain() {
        load_plugin_textdomain( 'ksus-map-try', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }
}
