( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"knmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + kn_map_try_config[id]['title']);
        var _abb = $('#' + kn_map_try_config[id]['title']);
        $('#knmapwrapper-try').css({'opacity': '1'});

        if(kn_map_try_config['default']['knshowvisns_try'] === true) {
            $('#knvisns-try').css({'fill': kn_map_try_config['default']['knvisns_try']});
            $('#knvisns-try').css({'opacity': '1'});
        } else {
            $('#knvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': kn_map_try_config[id]['upclr'], 'stroke': kn_map_try_config['default']['knbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (kn_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $knmtip = $('#tipknmap-try');
                            let knmaptipw = $knmtip.outerWidth(),
                                knmaptiph = $knmtip.outerHeight();

                            x = (x + knmaptipw > $(document).scrollLeft() + $(window).width()) ? x - knmaptipw - (20 * 2) : x
                            y = (y + knmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - knmaptiph - 10 : y

                            if (kn_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': kn_map_try_config[id]['dwnclr']});
                            }
                            $knmtip.show().html(kn_map_try_config[id]['hover']);
                            $knmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': kn_map_try_config[id]['upclr']});
                            if (kn_map_try_config[id]['targt'] === '_blank') {
                                window.open(kn_map_try_config[id]['url']);
                            } else if (kn_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = kn_map_try_config[id]['url'];
                            }
                            $('#tipknmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipknmap-try').show().html(kn_map_try_config[id]['hover']);
                _obj.css({'fill': kn_map_try_config[id]['ovrclr']});
                _abb.css({'fill': kn_map_try_config['default']['knvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipknmap-try').hide();
                _obj.css({'fill': kn_map_try_config[id]['upclr']});
                _abb.css({'fill': kn_map_try_config['default']['knvisns_try']});
            });
            if (kn_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': kn_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': kn_map_try_config[id]['ovrclr']});
                if (kn_map_try_config[id]['targt'] === '_blank') {
                    window.open(kn_map_try_config[id]['url']);
                } else if (kn_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = kn_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mkn = $('#tipknmap-try');
                let knmaptipw = $mkn.outerWidth(), knmaptiph = $mkn.outerHeight();

                x = (x + knmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - knmaptipw - (20 * 2) : x
                y = (y + knmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - knmaptiph - 10 : y

                $mkn.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
