( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"itmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + it_map_try_config[id]['title']);
        var _abb = $('#' + it_map_try_config[id]['title']);
        $('#itmapwrapper-try').css({'opacity': '1'});

        if(it_map_try_config['default']['itshowvisns_try'] === true) {
            $('#itvisns-try').css({'fill': it_map_try_config['default']['itvisns_try']});
            $('#itvisns-try').css({'opacity': '1'});
        } else {
            $('#itvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': it_map_try_config[id]['upclr'], 'stroke': it_map_try_config['default']['itbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (it_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $itmtip = $('#tipitmap-try');
                            let itmaptipw = $itmtip.outerWidth(),
                                itmaptiph = $itmtip.outerHeight();

                            x = (x + itmaptipw > $(document).scrollLeft() + $(window).width()) ? x - itmaptipw - (20 * 2) : x
                            y = (y + itmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - itmaptiph - 10 : y

                            if (it_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': it_map_try_config[id]['dwnclr']});
                            }
                            $itmtip.show().html(it_map_try_config[id]['hover']);
                            $itmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': it_map_try_config[id]['upclr']});
                            if (it_map_try_config[id]['targt'] === '_blank') {
                                window.open(it_map_try_config[id]['url']);
                            } else if (it_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = it_map_try_config[id]['url'];
                            }
                            $('#tipitmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipitmap-try').show().html(it_map_try_config[id]['hover']);
                _obj.css({'fill': it_map_try_config[id]['ovrclr']});
                _abb.css({'fill': it_map_try_config['default']['itvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipitmap-try').hide();
                _obj.css({'fill': it_map_try_config[id]['upclr']});
                _abb.css({'fill': it_map_try_config['default']['itvisns_try']});
            });
            if (it_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': it_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': it_map_try_config[id]['ovrclr']});
                if (it_map_try_config[id]['targt'] === '_blank') {
                    window.open(it_map_try_config[id]['url']);
                } else if (it_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = it_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mit = $('#tipitmap-try');
                let itmaptipw = $mit.outerWidth(), itmaptiph = $mit.outerHeight();

                x = (x + itmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - itmaptipw - (20 * 2) : x
                y = (y + itmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - itmaptiph - 10 : y

                $mit.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
