( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"inmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + in_map_try_config[id]['title']);
        var _abb = $('#' + in_map_try_config[id]['title']);
        $('#inmapwrapper-try').css({'opacity': '1'});

        if(in_map_try_config['default']['inshowvisns_try'] === true) {
            $('#invisns-try').css({'fill': in_map_try_config['default']['invisns_try']});
            $('#invisns-try').css({'opacity': '1'});
        } else {
            $('#invisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': in_map_try_config[id]['upclr'], 'stroke': in_map_try_config['default']['inbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (in_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $inmtip = $('#tipinmap-try');
                            let inmaptipw = $inmtip.outerWidth(),
                                inmaptiph = $inmtip.outerHeight();

                            x = (x + inmaptipw > $(document).scrollLeft() + $(window).width()) ? x - inmaptipw - (20 * 2) : x
                            y = (y + inmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - inmaptiph - 10 : y

                            if (in_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': in_map_try_config[id]['dwnclr']});
                            }
                            $inmtip.show().html(in_map_try_config[id]['hover']);
                            $inmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': in_map_try_config[id]['upclr']});
                            if (in_map_try_config[id]['targt'] === '_blank') {
                                window.open(in_map_try_config[id]['url']);
                            } else if (in_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = in_map_try_config[id]['url'];
                            }
                            $('#tipinmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipinmap-try').show().html(in_map_try_config[id]['hover']);
                _obj.css({'fill': in_map_try_config[id]['ovrclr']});
                _abb.css({'fill': in_map_try_config['default']['invisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipinmap-try').hide();
                _obj.css({'fill': in_map_try_config[id]['upclr']});
                _abb.css({'fill': in_map_try_config['default']['invisns_try']});
            });
            if (in_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': in_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': in_map_try_config[id]['ovrclr']});
                if (in_map_try_config[id]['targt'] === '_blank') {
                    window.open(in_map_try_config[id]['url']);
                } else if (in_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = in_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $min = $('#tipinmap-try');
                let inmaptipw = $min.outerWidth(), inmaptiph = $min.outerHeight();

                x = (x + inmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - inmaptipw - (20 * 2) : x
                y = (y + inmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - inmaptiph - 10 : y

                $min.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
