( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"ilusmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ilus_map_try_config[id]['title']);
        var _abb = $('#' + ilus_map_try_config[id]['title']);
        $('#ilusmapwrapper-try').css({'opacity': '1'});

        if(ilus_map_try_config['default']['ilusshowvisns_try'] == 'Yes') {
            $('#ilusvisns-try').css({'fill': ilus_map_try_config['default']['ilusvisns_try']});
            $('#ilusvisns-try').css({'opacity': '1'});
        } else {
            $('#ilusvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ilus_map_try_config[id]['upColor'], 'stroke': ilus_map_try_config['default']['ilusbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ilus_map_try_config[id]['enble'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $ilusmtip = $('#tipilusmap-try');
                            let ilusmaptipw = $ilusmtip.outerWidth(),
                                ilusmaptiph = $ilusmtip.outerHeight();

                            x = (x + ilusmaptipw > $(document).scrollLeft() + $(window).width()) ? x - ilusmaptipw - (20 * 2) : x
                            y = (y + ilusmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - ilusmaptiph - 10 : y

                            if (ilus_map_try_config[id]['target'] !== 'none') {
                                _obj.css({'fill': ilus_map_try_config[id]['downColor']});
                            }
                            $ilusmtip.show().html(ilus_map_try_config[id]['hover']);
                            $ilusmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ilus_map_try_config[id]['upColor']});
                            if (ilus_map_try_config[id]['target'] === 'new') {
                                window.open(ilus_map_try_config[id]['url']);
                            } else if (ilus_map_try_config[id]['target'] === 'self') {
                                window.parent.location.href = ilus_map_try_config[id]['url'];
                            }
                            $('#tipilusmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipilusmap-try').show().html(ilus_map_try_config[id]['hover']);
                _obj.css({'fill': ilus_map_try_config[id]['overColor']});
                _abb.css({'fill': ilus_map_try_config['default']['ilusvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipilusmap-try').hide();
                _obj.css({'fill': ilus_map_try_config[id]['upColor']});
                _abb.css({'fill': ilus_map_try_config['default']['ilusvisns_try']});
            });
            if (ilus_map_try_config[id]['target'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ilus_map_try_config[id]['downColor']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ilus_map_try_config[id]['overColor']});
                if (ilus_map_try_config[id]['target'] === 'new') {
                    window.open(ilus_map_try_config[id]['url']);
                } else if (ilus_map_try_config[id]['target'] === 'self') {
                    window.parent.location.href = ilus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $milus = $('#tipilusmap-try');
                let ilusmaptipw = $milus.outerWidth(), ilusmaptiph = $milus.outerHeight();

                x = (x + ilusmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - ilusmaptipw - (20 * 2) : x
                y = (y + ilusmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - ilusmaptiph - 10 : y

                $milus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
