( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"iemapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ie_map_try_config[id]['title']);
        var _abb = $('#' + ie_map_try_config[id]['title']);
        $('#iemapwrapper-try').css({'opacity': '1'});

        if(ie_map_try_config['default']['ieshowvisns_try'] === true) {
            $('#ievisns-try').css({'fill': ie_map_try_config['default']['ievisns_try']});
            $('#ievisns-try').css({'opacity': '1'});
        } else {
            $('#ievisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ie_map_try_config[id]['upclr'], 'stroke': ie_map_try_config['default']['iebrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ie_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $iemtip = $('#tipiemap-try');
                            let iemaptipw = $iemtip.outerWidth(),
                                iemaptiph = $iemtip.outerHeight();

                            x = (x + iemaptipw > $(document).scrollLeft() + $(window).width()) ? x - iemaptipw - (20 * 2) : x
                            y = (y + iemaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - iemaptiph - 10 : y

                            if (ie_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': ie_map_try_config[id]['dwnclr']});
                            }
                            $iemtip.show().html(ie_map_try_config[id]['hover']);
                            $iemtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ie_map_try_config[id]['upclr']});
                            if (ie_map_try_config[id]['targt'] === '_blank') {
                                window.open(ie_map_try_config[id]['url']);
                            } else if (ie_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = ie_map_try_config[id]['url'];
                            }
                            $('#tipiemap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipiemap-try').show().html(ie_map_try_config[id]['hover']);
                _obj.css({'fill': ie_map_try_config[id]['ovrclr']});
                _abb.css({'fill': ie_map_try_config['default']['ievisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipiemap-try').hide();
                _obj.css({'fill': ie_map_try_config[id]['upclr']});
                _abb.css({'fill': ie_map_try_config['default']['ievisns_try']});
            });
            if (ie_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ie_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ie_map_try_config[id]['ovrclr']});
                if (ie_map_try_config[id]['targt'] === '_blank') {
                    window.open(ie_map_try_config[id]['url']);
                } else if (ie_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = ie_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mie = $('#tipiemap-try');
                let iemaptipw = $mie.outerWidth(), iemaptiph = $mie.outerHeight();

                x = (x + iemaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - iemaptipw - (20 * 2) : x
                y = (y + iemaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - iemaptiph - 10 : y

                $mie.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
