( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"idmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + id_map_try_config[id]['title']);
        var _abb = $('#' + id_map_try_config[id]['title']);
        $('#idmapwrapper-try').css({'opacity': '1'});

        if(id_map_try_config['default']['idshowvisns_try'] === true) {
            $('#idvisns-try').css({'fill': id_map_try_config['default']['idvisns_try']});
            $('#idvisns-try').css({'opacity': '1'});
        } else {
            $('#idvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': id_map_try_config[id]['upclr'], 'stroke': id_map_try_config['default']['idbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (id_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $idmtip = $('#tipidmap-try');
                            let idmaptipw = $idmtip.outerWidth(),
                                idmaptiph = $idmtip.outerHeight();

                            x = (x + idmaptipw > $(document).scrollLeft() + $(window).width()) ? x - idmaptipw - (20 * 2) : x
                            y = (y + idmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - idmaptiph - 10 : y

                            if (id_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': id_map_try_config[id]['dwnclr']});
                            }
                            $idmtip.show().html(id_map_try_config[id]['hover']);
                            $idmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': id_map_try_config[id]['upclr']});
                            if (id_map_try_config[id]['targt'] === '_blank') {
                                window.open(id_map_try_config[id]['url']);
                            } else if (id_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = id_map_try_config[id]['url'];
                            }
                            $('#tipidmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipidmap-try').show().html(id_map_try_config[id]['hover']);
                _obj.css({'fill': id_map_try_config[id]['ovrclr']});
                _abb.css({'fill': id_map_try_config['default']['idvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipidmap-try').hide();
                _obj.css({'fill': id_map_try_config[id]['upclr']});
                _abb.css({'fill': id_map_try_config['default']['idvisns_try']});
            });
            if (id_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': id_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': id_map_try_config[id]['ovrclr']});
                if (id_map_try_config[id]['targt'] === '_blank') {
                    window.open(id_map_try_config[id]['url']);
                } else if (id_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = id_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mid = $('#tipidmap-try');
                let idmaptipw = $mid.outerWidth(), idmaptiph = $mid.outerHeight();

                x = (x + idmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - idmaptipw - (20 * 2) : x
                y = (y + idmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - idmaptiph - 10 : y

                $mid.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
