<?php
/*
Plugin Name: Indonesia Map Try
Plugin URI: https://www.wpmapplugins.com/interactive-map-of-indonesia-wordpress-plugin.html
Description: Customize each province (colors, link, etc) through the map dashboard and use the shortcode in your page.
Version: 2.7
Author: WP Map Plugins
Author URI: https://www.wpmapplugins.com/
Text Domain: id-map-try
Domain Path: /languages
*/

declare(strict_types=1);

namespace IDMap_TRY;

use IDMap_TRY\IDMap_TRY;

if (!defined('IDMAP_TRY_VERSION')) {
    define('IDMAP_TRY_VERSION', '2.7');
}

if (!defined('IDMAP_TRY_DIR')) {
    define('IDMAP_TRY_DIR', plugin_dir_path(__FILE__));
}

if (!defined('IDMAP_TRY_URL')) {
    define('IDMAP_TRY_URL', plugin_dir_url(__FILE__));
}

(new IDMap_TRY())->init();

class IDMap_TRY {

    const PLUGIN_NAME = 'Indonesia Map Try';

    private $options = null;

    public function init() {
        $this->initActions();
        $this->initShortcodes();
        $this->initOptions();
    }

    private function initActions() {
    	if( !function_exists('wp_get_current_user') ) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        add_action( 'admin_menu', array($this, 'addOptionsPage') );
        add_action( 'admin_footer', array($this, 'addJsConfigInFooter') );
        add_action( 'wp_footer', array($this, 'addSpanTag') );
        add_action( 'admin_enqueue_scripts', array($this, 'initAdminScript') );
        add_action( 'init', array($this, 'loadTextdomain') );
    }

    private function initShortcodes() {
        add_shortcode('id_map_try', array($this, 'IDMap_TRYShortcode'));
    }

    private function initOptions() {
        $defaultOptions = $this->getDefaultOptions();
        $this->options  = get_option('id_map_try');

        if (current_user_can( 'manage_options' )){
            $this->updateOptions($defaultOptions);
        }

        if (!is_array($this->options)) {
            $this->options = $defaultOptions;
        }

        $this->prepareOptionsListForTpl();
    }

    public function addJsConfigInFooter() {
        echo wp_kses_post('<span id="tipidmap-try" style="margin-top:-32px"></span>');
        include __DIR__ . "/includes/js-config.php";
    }

    public function addOptionsPage() {
        add_menu_page(
            IDMap_TRY::PLUGIN_NAME,
            IDMap_TRY::PLUGIN_NAME,
            'manage_options',
            'id-map-try',
            array($this, 'optionsScreen'),
            IDMAP_TRY_URL . 'public/images/map-icon.png'
        );
    }

    /**
     * @return array
     */
    private function getDefaultOptions() {
        $default = array(
            'idbrdrclr_try'    => '#6B8B9E',
            'idshowvisns_try'  => 1,
            'idvisns_try'      => '#666666',
            'idvisnshover_try' => '#113e6b',
        );

        $areas = array(
            'ACEH', 'BALI', 'BANGKA–BELITUNG ISLANDS', 'BANTEN', 'BENGKULU', 'CENTRAL JAVA', 'CENTRAL KALIMANTAN', 'CENTRAL PAPUA', 'CENTRAL SULAWESI', 'EAST JAVA', 'EAST KALIMANTAN', 'EAST NUSA TENGGARA', 'GORONTALO', 'HIGHLAND PAPUA', 'JAKARTA', 'JAMBI', 'LAMPUNG', 'MALUKU', 'NORTH KALIMANTAN', 'NORTH MALUKU', 'NORTH SULAWESI', 'NORTH SUMATRA', 'PAPUA', 'RIAU', 'RIAU ISLANDS', 'SOUTHEAST SULAWESI', 'SOUTH KALIMANTAN', 'SOUTH PAPUA'
        );

        foreach ($areas as $k => $area) {
            $default['upclr_' . ($k + 1)]  = '#E0F3FF';
            $default['ovrclr_' . ($k + 1)] = '#8FBEE8';
            $default['dwnclr_' . ($k + 1)] = '#477CB2';
            $default['url_' . ($k + 1)]    = '';
            $default['turl_' . ($k + 1)]   = '_self';
            $default['info_' . ($k + 1)]   = $area;
            $default['enbl_' . ($k + 1)]   = 1;
        }

        return $default;
    }

    private function updateOptions(array $defaultOptions) {
        if (isset($_POST['id_map_try']) && isset($_POST['submit-clrs'])) {
            $i = 1;
            while (isset($_POST['url_' . $i])) {
                $_POST['upclr_' . $i]  = $_POST['upclr_all'];
                $_POST['ovrclr_' . $i] = $_POST['ovrclr_all'];
                $_POST['dwnclr_' . $i] = $_POST['dwnclr_all'];

                $i++;
            }

            update_option('id_map_try',$_POST);

            $this->options = $_POST;
        }

        if (isset($_POST['id_map_try']) && isset($_POST['submit-url'])) {
            $i = 1;
            while (isset($_POST['url_' . $i])) {
                $_POST['url_' . $i]  = $_POST['url_all'];
                $_POST['turl_' . $i] = $_POST['turl_all'];

                $i++;
            }

            update_option('id_map_try',$_POST);

            $this->options = $_POST;
        }

        if (isset($_POST['id_map_try']) && isset($_POST['submit-info'])) {
            $i = 1;
            while (isset($_POST['url_' . $i])) {
                $_POST['info_' . $i] = $_POST['info_all'];

                $i++;
            }

            update_option('id_map_try',$_POST);

            $this->options = $_POST;
        }

        if (isset($_POST['id_map_try']) && !isset($_POST['preview_map'])) {
            update_option('id_map_try',$_POST);

            $this->options = $_POST;
        }

        if (isset($_POST['id_map_try']) && isset($_POST['restore_default'])) {
            update_option('id_map_try', $defaultOptions);

            $this->options = $defaultOptions;
        }
    }

    private function prepareOptionsListForTpl() {
        $this->options['prepared_list'] = array();
        $i                              = 1;
        while (isset($this->options['url_' . $i])) {
            $this->options['prepared_list'][] = array(
                'index'  => $i,
                'info_'  => $this->options['info_' . $i],
                'url'    => $this->options['url_' . $i],
                'turl'   => $this->options['turl_' . $i],
                'upclr'  => $this->options['upclr_' . $i],
                'ovrclr' => $this->options['ovrclr_' . $i],
                'dwnclr' => $this->options['dwnclr_' . $i],
                'enbl'   => isset($this->options['enbl_' . $i]),
            );

            $i++;
        }
    }

    public function IDMap_TRYShortcode() {
        wp_enqueue_style('id-map-try-style-frontend', IDMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');
        wp_enqueue_script('id-map-try-interact', IDMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);

        ob_start();

        include __DIR__ . "/includes/map.php";
        include __DIR__ . "/includes/js-config.php";

        return ob_get_clean();
    }

    public function optionsScreen() {
        include __DIR__ . "/includes/admin.php";
    }

    public function initAdminScript() {
        if ( current_user_can( 'manage_options') && ( esc_attr(isset($_GET['page'])) && esc_attr($_GET['page']) == 'id-map-try') ):
            wp_enqueue_style('wp-color-picker');
            wp_enqueue_style('thickbox');
            wp_enqueue_script('thickbox');
            wp_enqueue_script('media-upload');

            wp_enqueue_style('id-map-try-dashboard-style', IDMAP_TRY_URL . 'public/css/dashboard-style.css', false, '1.0', 'all');
            wp_enqueue_style('id-map-try-style', IDMAP_TRY_URL . 'public/css/map-style.css', false, '1.0', 'all');
            wp_enqueue_style('wp-tinyeditor', IDMAP_TRY_URL . 'public/css/tinyeditor.css', false, '1.0', 'all');

            wp_enqueue_script('id-map-try-interact', IDMAP_TRY_URL . 'public/js/map-interact.js?t=' . time(), array('jquery'), 10, '1.0', true);
            wp_enqueue_script('id-map-try-tiny.editor', IDMAP_TRY_URL . 'public/js/editor/tinymce.min.js', 10, '1.0', true);
            wp_enqueue_script('id-map-try-script', IDMAP_TRY_URL . 'public/js/editor/scripts.js', array('wp-color-picker'), false, true);
        endif;
    }

    public function addSpanTag()
    {
        echo wp_kses_post('<span id="tipidmap-try"></span>');
    }
    
    public function loadTextdomain() {
        load_plugin_textdomain( 'id-map-try', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }
}
