( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"gausmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + gaus_map_try_config[id]['title']);
        var _abb = $('#' + gaus_map_try_config[id]['title']);
        $('#gausmapwrapper-try').css({'opacity': '1'});

        if(gaus_map_try_config['default']['gausshowvisns_try'] == 'Yes') {
            $('#gausvisns-try').css({'fill': gaus_map_try_config['default']['gausvisns_try']});
            $('#gausvisns-try').css({'opacity': '1'});
        } else {
            $('#gausvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': gaus_map_try_config[id]['upColor'], 'stroke': gaus_map_try_config['default']['gausbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (gaus_map_try_config[id]['enble'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $gausmtip = $('#tipgausmap-try');
                            let gausmaptipw = $gausmtip.outerWidth(),
                                gausmaptiph = $gausmtip.outerHeight();

                            x = (x + gausmaptipw > $(document).scrollLeft() + $(window).width()) ? x - gausmaptipw - (20 * 2) : x
                            y = (y + gausmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - gausmaptiph - 10 : y

                            if (gaus_map_try_config[id]['target'] !== 'none') {
                                _obj.css({'fill': gaus_map_try_config[id]['downColor']});
                            }
                            $gausmtip.show().html(gaus_map_try_config[id]['hover']);
                            $gausmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': gaus_map_try_config[id]['upColor']});
                            if (gaus_map_try_config[id]['target'] === 'new') {
                                window.open(gaus_map_try_config[id]['url']);
                            } else if (gaus_map_try_config[id]['target'] === 'self') {
                                window.parent.location.href = gaus_map_try_config[id]['url'];
                            }
                            $('#tipgausmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipgausmap-try').show().html(gaus_map_try_config[id]['hover']);
                _obj.css({'fill': gaus_map_try_config[id]['overColor']});
                _abb.css({'fill': gaus_map_try_config['default']['gausvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipgausmap-try').hide();
                _obj.css({'fill': gaus_map_try_config[id]['upColor']});
                _abb.css({'fill': gaus_map_try_config['default']['gausvisns_try']});
            });
            if (gaus_map_try_config[id]['target'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': gaus_map_try_config[id]['downColor']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': gaus_map_try_config[id]['overColor']});
                if (gaus_map_try_config[id]['target'] === 'new') {
                    window.open(gaus_map_try_config[id]['url']);
                } else if (gaus_map_try_config[id]['target'] === 'self') {
                    window.parent.location.href = gaus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mgaus = $('#tipgausmap-try');
                let gausmaptipw = $mgaus.outerWidth(), gausmaptiph = $mgaus.outerHeight();

                x = (x + gausmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - gausmaptipw - (20 * 2) : x
                y = (y + gausmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - gausmaptiph - 10 : y

                $mgaus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
