( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"frmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + fr_map_try_config[id]['title']);
        var _abb = $('#' + fr_map_try_config[id]['title']);
        $('#frmapwrapper-try').css({'opacity': '1'});

        if(fr_map_try_config['default']['frshowvisns_try'] === true) {
            $('#frvisns-try').css({'fill': fr_map_try_config['default']['frvisns_try']});
            $('#frvisns-try').css({'opacity': '1'});
        } else {
            $('#frvisns-try').css({'opacity': '0'});
        }

        if(fr_map_try_config['default']['frshowoverseas_try'] === true) {
            $('#frmapvtry_14' + ',' + '#frvnvtry_14' + ',' + '#frmapvtry_15' + ',' + '#frvnvtry_15' + ',' + '#frmapvtry_16' + ',' + '#frvnvtry_16' + ',' + '#frmapvtry_17' + ',' + '#frvnvtry_17' + ',' + '#frmapvtry_18' + ',' + '#frvnvtry_18').css({'visibility': 'visible'});
        } else {
            $('#frmapvtry_14' + ',' + '#frvnvtry_14' + ',' + '#frmapvtry_15' + ',' + '#frvnvtry_15' + ',' + '#frmapvtry_16' + ',' + '#frvnvtry_16' + ',' + '#frmapvtry_17' + ',' + '#frvnvtry_17' + ',' + '#frmapvtry_18' + ',' + '#frvnvtry_18').css({'visibility': 'hidden'});
        }

        _obj.attr({'fill': fr_map_try_config[id]['upclr'], 'stroke': fr_map_try_config['default']['frbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (fr_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $frmtip = $('#tipfrmap-try');
                            let frmaptipw = $frmtip.outerWidth(),
                                frmaptiph = $frmtip.outerHeight();

                            x = (x + frmaptipw > $(document).scrollLeft() + $(window).width()) ? x - frmaptipw - (20 * 2) : x
                            y = (y + frmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - frmaptiph - 10 : y

                            if (fr_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': fr_map_try_config[id]['dwnclr']});
                            }
                            $frmtip.show().html(fr_map_try_config[id]['hover']);
                            $frmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': fr_map_try_config[id]['upclr']});
                            if (fr_map_try_config[id]['targt'] === '_blank') {
                                window.open(fr_map_try_config[id]['url']);
                            } else if (fr_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = fr_map_try_config[id]['url'];
                            }
                            $('#tipfrmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipfrmap-try').show().html(fr_map_try_config[id]['hover']);
                _obj.css({'fill': fr_map_try_config[id]['ovrclr']});
                _abb.css({'fill': fr_map_try_config['default']['frvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipfrmap-try').hide();
                _obj.css({'fill': fr_map_try_config[id]['upclr']});
                _abb.css({'fill': fr_map_try_config['default']['frvisns_try']});
            });
            if (fr_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': fr_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': fr_map_try_config[id]['ovrclr']});
                if (fr_map_try_config[id]['targt'] === '_blank') {
                    window.open(fr_map_try_config[id]['url']);
                } else if (fr_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = fr_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mfr = $('#tipfrmap-try');
                let frmaptipw = $mfr.outerWidth(), frmaptiph = $mfr.outerHeight();

                x = (x + frmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - frmaptipw - (20 * 2) : x
                y = (y + frmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - frmaptiph - 10 : y

                $mfr.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
