( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"fimapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + fi_map_try_config[id]['title']);
        var _abb = $('#' + fi_map_try_config[id]['title']);
        $('#fimapwrapper-try').css({'opacity': '1'});

        if(fi_map_try_config['default']['fishowvisns_try'] === true) {
            $('#fivisns-try').css({'fill': fi_map_try_config['default']['fivisns_try']});
            $('#fivisns-try').css({'opacity': '1'});
        } else {
            $('#fivisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': fi_map_try_config[id]['upclr'], 'stroke': fi_map_try_config['default']['fibrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (fi_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $fimtip = $('#tipfimap-try');
                            let fimaptipw = $fimtip.outerWidth(),
                                fimaptiph = $fimtip.outerHeight();

                            x = (x + fimaptipw > $(document).scrollLeft() + $(window).width()) ? x - fimaptipw - (20 * 2) : x
                            y = (y + fimaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - fimaptiph - 10 : y

                            if (fi_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': fi_map_try_config[id]['dwnclr']});
                            }
                            $fimtip.show().html(fi_map_try_config[id]['hover']);
                            $fimtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': fi_map_try_config[id]['upclr']});
                            if (fi_map_try_config[id]['targt'] === '_blank') {
                                window.open(fi_map_try_config[id]['url']);
                            } else if (fi_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = fi_map_try_config[id]['url'];
                            }
                            $('#tipfimap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipfimap-try').show().html(fi_map_try_config[id]['hover']);
                _obj.css({'fill': fi_map_try_config[id]['ovrclr']});
                _abb.css({'fill': fi_map_try_config['default']['fivisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipfimap-try').hide();
                _obj.css({'fill': fi_map_try_config[id]['upclr']});
                _abb.css({'fill': fi_map_try_config['default']['fivisns_try']});
            });
            if (fi_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': fi_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': fi_map_try_config[id]['ovrclr']});
                if (fi_map_try_config[id]['targt'] === '_blank') {
                    window.open(fi_map_try_config[id]['url']);
                } else if (fi_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = fi_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mfi = $('#tipfimap-try');
                let fimaptipw = $mfi.outerWidth(), fimaptiph = $mfi.outerHeight();

                x = (x + fimaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - fimaptipw - (20 * 2) : x
                y = (y + fimaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - fimaptiph - 10 : y

                $mfi.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
