( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"eumapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + eu_map_try_config[id]['title']);
        var _abb = $('#' + eu_map_try_config[id]['title']);
        $('#eumapwrapper-try').css({'opacity': '1'});

        if(eu_map_try_config['default']['eushowvisns_try'] === true) {
            $('#euvisns-try').css({'fill': eu_map_try_config['default']['euvisns_try']});
            $('#euvisns-try').css({'opacity': '1'});
        } else {
            $('#euvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': eu_map_try_config[id]['upclr'], 'stroke': eu_map_try_config['default']['eubrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (eu_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $eumtip = $('#tipeumap-try');
                            let eumaptipw = $eumtip.outerWidth(),
                                eumaptiph = $eumtip.outerHeight();

                            x = (x + eumaptipw > $(document).scrollLeft() + $(window).width()) ? x - eumaptipw - (20 * 2) : x
                            y = (y + eumaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - eumaptiph - 10 : y

                            if (eu_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': eu_map_try_config[id]['dwnclr']});
                            }
                            $eumtip.show().html(eu_map_try_config[id]['hover']);
                            $eumtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': eu_map_try_config[id]['upclr']});
                            if (eu_map_try_config[id]['targt'] === '_blank') {
                                window.open(eu_map_try_config[id]['url']);
                            } else if (eu_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = eu_map_try_config[id]['url'];
                            }
                            $('#tipeumap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipeumap-try').show().html(eu_map_try_config[id]['hover']);
                _obj.css({'fill': eu_map_try_config[id]['ovrclr']});
                _abb.css({'fill': eu_map_try_config['default']['euvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipeumap-try').hide();
                _obj.css({'fill': eu_map_try_config[id]['upclr']});
                _abb.css({'fill': eu_map_try_config['default']['euvisns_try']});
            });
            if (eu_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': eu_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': eu_map_try_config[id]['ovrclr']});
                if (eu_map_try_config[id]['targt'] === '_blank') {
                    window.open(eu_map_try_config[id]['url']);
                } else if (eu_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = eu_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $meu = $('#tipeumap-try');
                let eumaptipw = $meu.outerWidth(), eumaptiph = $meu.outerHeight();

                x = (x + eumaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - eumaptipw - (20 * 2) : x
                y = (y + eumaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - eumaptiph - 10 : y

                $meu.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
