( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"dkmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + dk_map_try_config[id]['title']);
        var _abb = $('#' + dk_map_try_config[id]['title']);
        $('#dkmapwrapper-try').css({'opacity': '1'});

        if(dk_map_try_config['default']['dkshowvisns_try'] === true) {
            $('#dkvisns-try').css({'fill': dk_map_try_config['default']['dkvisns_try']});
            $('#dkvisns-try').css({'opacity': '1'});
        } else {
            $('#dkvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': dk_map_try_config[id]['upclr'], 'stroke': dk_map_try_config['default']['dkbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (dk_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $dkmtip = $('#tipdkmap-try');
                            let dkmaptipw = $dkmtip.outerWidth(),
                                dkmaptiph = $dkmtip.outerHeight();

                            x = (x + dkmaptipw > $(document).scrollLeft() + $(window).width()) ? x - dkmaptipw - (20 * 2) : x
                            y = (y + dkmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - dkmaptiph - 10 : y

                            if (dk_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': dk_map_try_config[id]['dwnclr']});
                            }
                            $dkmtip.show().html(dk_map_try_config[id]['hover']);
                            $dkmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': dk_map_try_config[id]['upclr']});
                            if (dk_map_try_config[id]['targt'] === '_blank') {
                                window.open(dk_map_try_config[id]['url']);
                            } else if (dk_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = dk_map_try_config[id]['url'];
                            }
                            $('#tipdkmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipdkmap-try').show().html(dk_map_try_config[id]['hover']);
                _obj.css({'fill': dk_map_try_config[id]['ovrclr']});
                _abb.css({'fill': dk_map_try_config['default']['dkvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipdkmap-try').hide();
                _obj.css({'fill': dk_map_try_config[id]['upclr']});
                _abb.css({'fill': dk_map_try_config['default']['dkvisns_try']});
            });
            if (dk_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': dk_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': dk_map_try_config[id]['ovrclr']});
                if (dk_map_try_config[id]['targt'] === '_blank') {
                    window.open(dk_map_try_config[id]['url']);
                } else if (dk_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = dk_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mdk = $('#tipdkmap-try');
                let dkmaptipw = $mdk.outerWidth(), dkmaptiph = $mdk.outerHeight();

                x = (x + dkmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - dkmaptipw - (20 * 2) : x
                y = (y + dkmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - dkmaptiph - 10 : y

                $mdk.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
