( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"causmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + caus_map_try_config[id]['title']);
        var _abb = $('#' + caus_map_try_config[id]['title']);
        $('#causmapwrapper-try').css({'opacity': '1'});

        if(caus_map_try_config['default']['causshowvisns_try'] === true) {
            $('#causvisns-try').css({'fill': caus_map_try_config['default']['causvisns_try']});
            $('#causvisns-try').css({'opacity': '1'});
        } else {
            $('#causvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': caus_map_try_config[id]['upclr'], 'stroke': caus_map_try_config['default']['causbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (caus_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $causmtip = $('#tipcausmap-try');
                            let causmaptipw = $causmtip.outerWidth(),
                                causmaptiph = $causmtip.outerHeight();

                            x = (x + causmaptipw > $(document).scrollLeft() + $(window).width()) ? x - causmaptipw - (20 * 2) : x
                            y = (y + causmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - causmaptiph - 10 : y

                            if (caus_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': caus_map_try_config[id]['dwnclr']});
                            }
                            $causmtip.show().html(caus_map_try_config[id]['hover']);
                            $causmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': caus_map_try_config[id]['upclr']});
                            if (caus_map_try_config[id]['targt'] === '_blank') {
                                window.open(caus_map_try_config[id]['url']);
                            } else if (caus_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = caus_map_try_config[id]['url'];
                            }
                            $('#tipcausmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipcausmap-try').show().html(caus_map_try_config[id]['hover']);
                _obj.css({'fill': caus_map_try_config[id]['ovrclr']});
                _abb.css({'fill': caus_map_try_config['default']['causvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipcausmap-try').hide();
                _obj.css({'fill': caus_map_try_config[id]['upclr']});
                _abb.css({'fill': caus_map_try_config['default']['causvisns_try']});
            });
            if (caus_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': caus_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': caus_map_try_config[id]['ovrclr']});
                if (caus_map_try_config[id]['targt'] === '_blank') {
                    window.open(caus_map_try_config[id]['url']);
                } else if (caus_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = caus_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mcaus = $('#tipcausmap-try');
                let causmaptipw = $mcaus.outerWidth(), causmaptiph = $mcaus.outerHeight();

                x = (x + causmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - causmaptipw - (20 * 2) : x
                y = (y + causmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - causmaptiph - 10 : y

                $mcaus.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
