( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"camapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ca_map_try_config[id]['title']);
        var _abb = $('#' + ca_map_try_config[id]['title']);
        $('#camapwrapper-try').css({'opacity': '1'});

        if(ca_map_try_config['default']['cashowvisns_try'] === true) {
            $('#cavisns-try').css({'fill': ca_map_try_config['default']['cavisns_try']});
            $('#cavisns-try').css({'opacity': '1'});
        } else {
            $('#cavisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ca_map_try_config[id]['upclr'], 'stroke': ca_map_try_config['default']['cabrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ca_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $camtip = $('#tipcamap-try');
                            let camaptipw = $camtip.outerWidth(),
                                camaptiph = $camtip.outerHeight();

                            x = (x + camaptipw > $(document).scrollLeft() + $(window).width()) ? x - camaptipw - (20 * 2) : x
                            y = (y + camaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - camaptiph - 10 : y

                            if (ca_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': ca_map_try_config[id]['dwnclr']});
                            }
                            $camtip.show().html(ca_map_try_config[id]['hover']);
                            $camtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ca_map_try_config[id]['upclr']});
                            if (ca_map_try_config[id]['targt'] === '_blank') {
                                window.open(ca_map_try_config[id]['url']);
                            } else if (ca_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = ca_map_try_config[id]['url'];
                            }
                            $('#tipcamap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipcamap-try').show().html(ca_map_try_config[id]['hover']);
                _obj.css({'fill': ca_map_try_config[id]['ovrclr']});
                _abb.css({'fill': ca_map_try_config['default']['cavisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipcamap-try').hide();
                _obj.css({'fill': ca_map_try_config[id]['upclr']});
                _abb.css({'fill': ca_map_try_config['default']['cavisns_try']});
            });
            if (ca_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ca_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ca_map_try_config[id]['ovrclr']});
                if (ca_map_try_config[id]['targt'] === '_blank') {
                    window.open(ca_map_try_config[id]['url']);
                } else if (ca_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = ca_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mca = $('#tipcamap-try');
                let camaptipw = $mca.outerWidth(), camaptiph = $mca.outerHeight();

                x = (x + camaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - camaptipw - (20 * 2) : x
                y = (y + camaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - camaptiph - 10 : y

                $mca.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
