( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"brmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + br_map_try_config[id]['title']);
        var _abb = $('#' + br_map_try_config[id]['title']);
        $('#brmapwrapper-try').css({'opacity': '1'});

        if(br_map_try_config['default']['brshowvisns_try'] === true) {
            $('#brvisns-try').css({'fill': br_map_try_config['default']['brvisns_try']});
            $('#brvisns-try').css({'opacity': '1'});
        } else {
            $('#brvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': br_map_try_config[id]['upclr'], 'stroke': br_map_try_config['default']['brbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (br_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $brmtip = $('#tipbrmap-try');
                            let brmaptipw = $brmtip.outerWidth(),
                                brmaptiph = $brmtip.outerHeight();

                            x = (x + brmaptipw > $(document).scrollLeft() + $(window).width()) ? x - brmaptipw - (20 * 2) : x
                            y = (y + brmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - brmaptiph - 10 : y

                            if (br_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': br_map_try_config[id]['dwnclr']});
                            }
                            $brmtip.show().html(br_map_try_config[id]['hover']);
                            $brmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': br_map_try_config[id]['upclr']});
                            if (br_map_try_config[id]['targt'] === '_blank') {
                                window.open(br_map_try_config[id]['url']);
                            } else if (br_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = br_map_try_config[id]['url'];
                            }
                            $('#tipbrmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipbrmap-try').show().html(br_map_try_config[id]['hover']);
                _obj.css({'fill': br_map_try_config[id]['ovrclr']});
                _abb.css({'fill': br_map_try_config['default']['brvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipbrmap-try').hide();
                _obj.css({'fill': br_map_try_config[id]['upclr']});
                _abb.css({'fill': br_map_try_config['default']['brvisns_try']});
            });
            if (br_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': br_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': br_map_try_config[id]['ovrclr']});
                if (br_map_try_config[id]['targt'] === '_blank') {
                    window.open(br_map_try_config[id]['url']);
                } else if (br_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = br_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mbr = $('#tipbrmap-try');
                let brmaptipw = $mbr.outerWidth(), brmaptiph = $mbr.outerHeight();

                x = (x + brmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - brmaptipw - (20 * 2) : x
                y = (y + brmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - brmaptiph - 10 : y

                $mbr.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
