( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"aumapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + au_map_try_config[id]['title']);
        var _abb = $('#' + au_map_try_config[id]['title']);
        $('#aumapwrapper-try').css({'opacity': '1'});

        if(au_map_try_config['default']['aushowvisns_try'] === true) {
            $('#auvisns-try').css({'fill': au_map_try_config['default']['auvisns_try']});
            $('#auvisns-try').css({'opacity': '1'});
        } else {
            $('#auvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': au_map_try_config[id]['upclr'], 'stroke': au_map_try_config['default']['aubrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (au_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $aumtip = $('#tipaumap-try');
                            let aumaptipw = $aumtip.outerWidth(),
                                aumaptiph = $aumtip.outerHeight();

                            x = (x + aumaptipw > $(document).scrollLeft() + $(window).width()) ? x - aumaptipw - (20 * 2) : x
                            y = (y + aumaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - aumaptiph - 10 : y

                            if (au_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': au_map_try_config[id]['dwnclr']});
                            }
                            $aumtip.show().html(au_map_try_config[id]['hover']);
                            $aumtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': au_map_try_config[id]['upclr']});
                            if (au_map_try_config[id]['targt'] === '_blank') {
                                window.open(au_map_try_config[id]['url']);
                            } else if (au_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = au_map_try_config[id]['url'];
                            }
                            $('#tipaumap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipaumap-try').show().html(au_map_try_config[id]['hover']);
                _obj.css({'fill': au_map_try_config[id]['ovrclr']});
                _abb.css({'fill': au_map_try_config['default']['auvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipaumap-try').hide();
                _obj.css({'fill': au_map_try_config[id]['upclr']});
                _abb.css({'fill': au_map_try_config['default']['auvisns_try']});
            });
            if (au_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': au_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': au_map_try_config[id]['ovrclr']});
                if (au_map_try_config[id]['targt'] === '_blank') {
                    window.open(au_map_try_config[id]['url']);
                } else if (au_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = au_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mau = $('#tipaumap-try');
                let aumaptipw = $mau.outerWidth(), aumaptiph = $mau.outerHeight();

                x = (x + aumaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - aumaptipw - (20 * 2) : x
                y = (y + aumaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - aumaptiph - 10 : y

                $mau.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
