( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"asmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + as_map_try_config[id]['title']);
        var _abb = $('#' + as_map_try_config[id]['title']);
        $('#asmapwrapper-try').css({'opacity': '1'});

        if(as_map_try_config['default']['asshowvisns_try'] === true) {
            $('#asvisns-try').css({'fill': as_map_try_config['default']['asvisns_try']});
            $('#asvisns-try').css({'opacity': '1'});
        } else {
            $('#asvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': as_map_try_config[id]['upclr'], 'stroke': as_map_try_config['default']['asbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (as_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $asmtip = $('#tipasmap-try');
                            let asmaptipw = $asmtip.outerWidth(),
                                asmaptiph = $asmtip.outerHeight();

                            x = (x + asmaptipw > $(document).scrollLeft() + $(window).width()) ? x - asmaptipw - (20 * 2) : x
                            y = (y + asmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - asmaptiph - 10 : y

                            if (as_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': as_map_try_config[id]['dwnclr']});
                            }
                            $asmtip.show().html(as_map_try_config[id]['hover']);
                            $asmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': as_map_try_config[id]['upclr']});
                            if (as_map_try_config[id]['targt'] === '_blank') {
                                window.open(as_map_try_config[id]['url']);
                            } else if (as_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = as_map_try_config[id]['url'];
                            }
                            $('#tipasmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipasmap-try').show().html(as_map_try_config[id]['hover']);
                _obj.css({'fill': as_map_try_config[id]['ovrclr']});
                _abb.css({'fill': as_map_try_config['default']['asvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipasmap-try').hide();
                _obj.css({'fill': as_map_try_config[id]['upclr']});
                _abb.css({'fill': as_map_try_config['default']['asvisns_try']});
            });
            if (as_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': as_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': as_map_try_config[id]['ovrclr']});
                if (as_map_try_config[id]['targt'] === '_blank') {
                    window.open(as_map_try_config[id]['url']);
                } else if (as_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = as_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mas = $('#tipasmap-try');
                let asmaptipw = $mas.outerWidth(), asmaptiph = $mas.outerHeight();

                x = (x + asmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - asmaptipw - (20 * 2) : x
                y = (y + asmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - asmaptiph - 10 : y

                $mas.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
