( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"armapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + ar_map_try_config[id]['title']);
        var _abb = $('#' + ar_map_try_config[id]['title']);
        $('#armapwrapper-try').css({'opacity': '1'});

        if(ar_map_try_config['default']['arshowvisns_try'] === true) {
            $('#arvisns-try').css({'fill': ar_map_try_config['default']['arvisns_try']});
            $('#arvisns-try').css({'opacity': '1'});
        } else {
            $('#arvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': ar_map_try_config[id]['upclr'], 'stroke': ar_map_try_config['default']['arbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (ar_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $armtip = $('#tiparmap-try');
                            let armaptipw = $armtip.outerWidth(),
                                armaptiph = $armtip.outerHeight();

                            x = (x + armaptipw > $(document).scrollLeft() + $(window).width()) ? x - armaptipw - (20 * 2) : x
                            y = (y + armaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - armaptiph - 10 : y

                            if (ar_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': ar_map_try_config[id]['dwnclr']});
                            }
                            $armtip.show().html(ar_map_try_config[id]['hover']);
                            $armtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': ar_map_try_config[id]['upclr']});
                            if (ar_map_try_config[id]['targt'] === '_blank') {
                                window.open(ar_map_try_config[id]['url']);
                            } else if (ar_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = ar_map_try_config[id]['url'];
                            }
                            $('#tiparmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tiparmap-try').show().html(ar_map_try_config[id]['hover']);
                _obj.css({'fill': ar_map_try_config[id]['ovrclr']});
                _abb.css({'fill': ar_map_try_config['default']['arvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tiparmap-try').hide();
                _obj.css({'fill': ar_map_try_config[id]['upclr']});
                _abb.css({'fill': ar_map_try_config['default']['arvisns_try']});
            });
            if (ar_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': ar_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': ar_map_try_config[id]['ovrclr']});
                if (ar_map_try_config[id]['targt'] === '_blank') {
                    window.open(ar_map_try_config[id]['url']);
                } else if (ar_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = ar_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $mar = $('#tiparmap-try');
                let armaptipw = $mar.outerWidth(), armaptiph = $mar.outerHeight();

                x = (x + armaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - armaptipw - (20 * 2) : x
                y = (y + armaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - armaptiph - 10 : y

                $mar.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
