( function( $ ) {

    "use strict";

    function isTouchEnabled() {
    return (('ontouchstart' in window)
        || (navigator.MaxTouchPoints > 0)
        || (navigator.msMaxTouchPoints > 0));
    }

    $(document).ready(function () {
        $("path[id^=\"afmapvtry_\"]").each(function (i, e) {
            addEvent($(e).attr('id'));
        });
    });

    function addEvent(id, relationId) {
        var _obj = $('#' + id);
        var _Textobj = $('#' + id + ',' + '#' + af_map_try_config[id]['title']);
        var _abb = $('#' + af_map_try_config[id]['title']);
        $('#afmapwrapper-try').css({'opacity': '1'});

        if(af_map_try_config['default']['afshowvisns_try'] === true) {
            $('#afvisns-try').css({'fill': af_map_try_config['default']['afvisns_try']});
            $('#afvisns-try').css({'opacity': '1'});
        } else {
            $('#afvisns-try').css({'opacity': '0'});
        }

        _obj.attr({'fill': af_map_try_config[id]['upclr'], 'stroke': af_map_try_config['default']['afbrdrclr_try']});

        _Textobj.attr({'cursor': 'default'});

        if (af_map_try_config[id]['enbl'] === true) {
            if (isTouchEnabled()) {
                var touchmoved;
                _Textobj.on('touchend', function (e) {
                    if (touchmoved !== true) {
                        _Textobj.on('touchstart', function (e) {
                            let touch = e.originalEvent.touches[0];
                            let x = touch.pageX - 10, y = touch.pageY + (-15);

                            let $afmtip = $('#tipafmap-try');
                            let afmaptipw = $afmtip.outerWidth(),
                                afmaptiph = $afmtip.outerHeight();

                            x = (x + afmaptipw > $(document).scrollLeft() + $(window).width()) ? x - afmaptipw - (20 * 2) : x
                            y = (y + afmaptiph > $(document).scrollTop() + $(window).height()) ? $(document).scrollTop() + $(window).height() - afmaptiph - 10 : y

                            if (af_map_try_config[id]['targt'] !== 'none') {
                                _obj.css({'fill': af_map_try_config[id]['dwnclr']});
                            }
                            $afmtip.show().html(af_map_try_config[id]['hover']);
                            $afmtip.css({left: x, top: y})
                        })
                        _Textobj.on('touchend', function () {
                            _obj.css({'fill': af_map_try_config[id]['upclr']});
                            if (af_map_try_config[id]['targt'] === '_blank') {
                                window.open(af_map_try_config[id]['url']);
                            } else if (af_map_try_config[id]['targt'] === '_self') {
                                window.parent.location.href = af_map_try_config[id]['url'];
                            }
                            $('#tipafmap-try').hide();
                        })
                    }
                }).on('touchmove', function (e) {
                    touchmoved = true;
                }).on('touchstart', function () {
                    touchmoved = false;
                });
            }
            _Textobj.attr({'cursor': 'pointer'});

            _Textobj.on('mouseenter', function () {
                $('#tipafmap-try').show().html(af_map_try_config[id]['hover']);
                _obj.css({'fill': af_map_try_config[id]['ovrclr']});
                _abb.css({'fill': af_map_try_config['default']['afvisnshover_try']});
            }).on('mouseleave', function () {
                $('#tipafmap-try').hide();
                _obj.css({'fill': af_map_try_config[id]['upclr']});
                _abb.css({'fill': af_map_try_config['default']['afvisns_try']});
            });
            if (af_map_try_config[id]['targt'] !== 'none') {
                _Textobj.on('mousedown', function () {
                    _obj.css({'fill': af_map_try_config[id]['dwnclr']});
                });
            }
            _Textobj.on('mouseup', function () {
                _obj.css({'fill': af_map_try_config[id]['ovrclr']});
                if (af_map_try_config[id]['targt'] === '_blank') {
                    window.open(af_map_try_config[id]['url']);
                } else if (af_map_try_config[id]['targt'] === '_self') {
                    window.parent.location.href = af_map_try_config[id]['url'];
                }
            });
            _Textobj.on('mousemove', function (e) {
                let x = e.pageX + 10, y = e.pageY + 15;

                let $maf = $('#tipafmap-try');
                let afmaptipw = $maf.outerWidth(), afmaptiph = $maf.outerHeight();

                x = (x + afmaptipw > $(document).scrollLeft() +
                    $(window).width()) ? x - afmaptipw - (20 * 2) : x
                y = (y + afmaptiph > $(document).scrollTop() + $(window).height()) ?
                    $(document).scrollTop() + $(window).height() - afmaptiph - 10 : y

                $maf.css({left: x, top: y})
            })
        }
        else {
            _abb.css({'fill-opacity':'0.5'});
        }
    }
})(jQuery);
